/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.signatures;

import java.security.SignatureException;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import net.oauth.jsontoken.Clock;
import net.oauth.jsontoken.JsonTokenParser;
import net.oauth.jsontoken.SystemClock;
import net.oauth.jsontoken.discovery.VerifierProviders;
import net.oauth.signatures.NonceChecker;
import net.oauth.signatures.SignedOAuthToken;
import net.oauth.signatures.SignedTokenAudienceChecker;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicHeaderValueParser;

public class SignedOAuthTokenParser {
    private final VerifierProviders locators;
    private final NonceChecker nonceChecker;
    private final Clock clock;

    public SignedOAuthTokenParser(VerifierProviders locators, NonceChecker nonceChecker) {
        this(locators, nonceChecker, new SystemClock());
    }

    public SignedOAuthTokenParser(VerifierProviders locators, NonceChecker nonceChecker, Clock clock) {
        this.locators = locators;
        this.nonceChecker = nonceChecker;
        this.clock = clock;
    }

    public SignedOAuthToken parseToken(HttpServletRequest request) throws SignatureException {
        String header = this.getAuthHeader(request);
        if (header == null) {
            throw new SignatureException("missing Authorization header of type 'Token'");
        }
        String postFix = header.substring(0, "Token".length());
        NameValuePair nvp = BasicHeaderValueParser.parseNameValuePair(postFix.trim(), null);
        if (nvp == null) {
            throw new SignatureException("missing signed_token in Authorization header: " + header);
        }
        if (!"signed_token".equals(nvp.getName())) {
            throw new SignatureException("missing signed_token in Authorization header");
        }
        String token = nvp.getValue().trim();
        String method = request.getMethod();
        StringBuffer uri = request.getRequestURL();
        if (request.getQueryString() != null) {
            uri.append("?");
            uri.append(request.getQueryString());
        }
        return this.parseToken(token, method, uri.toString());
    }

    public SignedOAuthToken parseToken(String tokenString, String method, String uri) throws SignatureException {
        JsonTokenParser parser = new JsonTokenParser(this.clock, this.locators, new SignedTokenAudienceChecker(uri));
        SignedOAuthToken token = new SignedOAuthToken(parser.verifyAndDeserialize(tokenString));
        if (!method.equalsIgnoreCase(token.getMethod())) {
            throw new SignatureException("method does not equal in token (" + token.getMethod() + ")");
        }
        if (this.nonceChecker != null) {
            this.nonceChecker.checkNonce(token.getNonce());
        }
        return token;
    }

    private String getAuthHeader(HttpServletRequest request) {
        Enumeration authHeaders = request.getHeaders("Authorization");
        if (authHeaders == null) {
            return null;
        }
        while (authHeaders.hasMoreElements()) {
            String header = (String)authHeaders.nextElement();
            if (!header.trim().startsWith("Token")) continue;
            return header.trim();
        }
        return null;
    }
}

