/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.document.conversion.internal;

import com.artofsolving.jodconverter.DefaultDocumentFormatRegistry;
import com.artofsolving.jodconverter.DocumentConverter;
import com.artofsolving.jodconverter.DocumentFormat;
import com.artofsolving.jodconverter.openoffice.connection.OpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.connection.SocketOpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.converter.OpenOfficeDocumentConverter;
import com.artofsolving.jodconverter.openoffice.converter.StreamOpenOfficeDocumentConverter;
import com.liferay.document.library.document.conversion.internal.DocumentHTMLProcessor;
import com.liferay.document.library.document.conversion.internal.configuration.OpenOfficeConfiguration;
import com.liferay.document.library.kernel.document.conversion.DocumentConversion;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.SortedArrayList;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;

@Component(configurationPid={"com.liferay.document.library.document.conversion.internal.configuration.OpenOfficeConfiguration"}, service={DocumentConversion.class})
public class DocumentConversionImpl
implements DocumentConversion {
    private static final String[] _COMPARABLE_FILE_EXTENSIONS = PropsValues.DL_COMPARABLE_FILE_EXTENSIONS;
    private static final String[] _DEFAULT_CONVERSIONS = new String[0];
    private static final String _LOCALHOST = "localhost";
    private static final String _LOCALHOST_IP = "127.0.0.1";
    private static final Log _log = LogFactoryUtil.getLog(DocumentConversionImpl.class);
    private DocumentConverter _documentConverter;
    private volatile OpenOfficeConfiguration _openOfficeConfiguration;
    private OpenOfficeConnection _openOfficeConnection;

    public File convert(String id, InputStream inputStream, String sourceExtension, String targetExtension) throws IOException {
        if (!this.isEnabled()) {
            return null;
        }
        sourceExtension = this._fixExtension(sourceExtension);
        targetExtension = this._fixExtension(targetExtension);
        this._validate(targetExtension, id);
        String fileName = this.getFilePath(id, targetExtension);
        File file = new File(fileName);
        if (this._openOfficeConfiguration.cacheEnabled() && file.exists()) {
            return file;
        }
        DefaultDocumentFormatRegistry documentFormatRegistry = new DefaultDocumentFormatRegistry();
        DocumentFormat inputDocumentFormat = documentFormatRegistry.getFormatByFileExtension(sourceExtension);
        DocumentFormat outputDocumentFormat = documentFormatRegistry.getFormatByFileExtension(targetExtension);
        if (inputDocumentFormat == null) {
            throw new SystemException("Conversion is not supported from ." + sourceExtension);
        }
        if (!inputDocumentFormat.isImportable()) {
            throw new SystemException("Conversion is not supported from " + inputDocumentFormat.getName());
        }
        if (outputDocumentFormat == null) {
            throw new SystemException(StringBundler.concat((String[])new String[]{"Conversion is not supported from ", inputDocumentFormat.getName(), " to .", targetExtension}));
        }
        if (!inputDocumentFormat.isExportableTo(outputDocumentFormat)) {
            throw new SystemException(StringBundler.concat((String[])new String[]{"Conversion is not supported from ", inputDocumentFormat.getName(), " to ", outputDocumentFormat.getName()}));
        }
        if (sourceExtension.equals("html")) {
            DocumentHTMLProcessor documentHTMLProcessor = new DocumentHTMLProcessor();
            inputStream = documentHTMLProcessor.process(inputStream);
        }
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        DocumentConverter documentConverter = this._getDocumentConverter();
        documentConverter.convert(inputStream, inputDocumentFormat, (OutputStream)unsyncByteArrayOutputStream, outputDocumentFormat);
        FileUtil.write((File)file, (byte[])unsyncByteArrayOutputStream.unsafeGetByteArray(), (int)0, (int)unsyncByteArrayOutputStream.size());
        inputStream.close();
        return file;
    }

    public void disconnect() {
        if (this._openOfficeConnection != null) {
            this._openOfficeConnection.disconnect();
        }
    }

    public String[] getConversions(String extension) {
        Object[] conversions = ConversionsHolder.getConversions(extension = this._fixExtension(extension));
        if (conversions == null) {
            conversions = _DEFAULT_CONVERSIONS;
        } else if (ArrayUtil.contains((Object[])conversions, (Object)extension)) {
            ArrayList<Object> conversionsList = new ArrayList<Object>();
            for (Object conversion : conversions) {
                if (((String)conversion).equals(extension)) continue;
                conversionsList.add(conversion);
            }
            conversions = conversionsList.toArray(new String[0]);
        }
        return conversions;
    }

    public String getFilePath(String id, String targetExtension) {
        StringBundler sb = new StringBundler(5);
        sb.append(SystemProperties.get((String)"java.io.tmpdir"));
        sb.append("/liferay/document_conversion/");
        sb.append(id);
        sb.append(".");
        sb.append(targetExtension);
        return sb.toString();
    }

    public boolean isComparableVersion(String extension) {
        boolean enabled = false;
        String periodAndExtension = ".".concat(extension);
        for (String comparableFileExtension : _COMPARABLE_FILE_EXTENSIONS) {
            if (!"*".equals(comparableFileExtension) && !periodAndExtension.equals(comparableFileExtension)) continue;
            enabled = true;
            break;
        }
        if (!enabled) {
            return false;
        }
        if (extension.equals("css") || extension.equals("htm") || extension.equals("html") || extension.equals("js") || extension.equals("txt") || extension.equals("xml")) {
            return true;
        }
        try {
            if (this.isEnabled() && this.isConvertBeforeCompare(extension)) {
                return true;
            }
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
        }
        return false;
    }

    public boolean isConvertBeforeCompare(String extension) {
        if (extension.equals("txt")) {
            return false;
        }
        for (String conversion : this.getConversions(extension)) {
            if (!conversion.equals("txt")) continue;
            return true;
        }
        return false;
    }

    public boolean isEnabled() {
        return this._openOfficeConfiguration.serverEnabled();
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._openOfficeConfiguration = (OpenOfficeConfiguration)ConfigurableUtil.createConfigurable(OpenOfficeConfiguration.class, properties);
    }

    private String _fixExtension(String extension) {
        if (extension.equals("htm")) {
            extension = "html";
        }
        return extension;
    }

    private DocumentConverter _getDocumentConverter() {
        if (this._openOfficeConnection != null && this._documentConverter != null) {
            return this._documentConverter;
        }
        String host = this._openOfficeConfiguration.serverHost();
        int port = this._openOfficeConfiguration.serverPort();
        if (this._isRemoteOpenOfficeHost(host)) {
            this._openOfficeConnection = new SocketOpenOfficeConnection(host, port);
            this._documentConverter = new StreamOpenOfficeDocumentConverter(this._openOfficeConnection);
        } else {
            this._openOfficeConnection = new SocketOpenOfficeConnection(port);
            this._documentConverter = new OpenOfficeDocumentConverter(this._openOfficeConnection);
        }
        return this._documentConverter;
    }

    private boolean _isRemoteOpenOfficeHost(String host) {
        return Validator.isNotNull((String)host) && !host.equals(_LOCALHOST_IP) && !host.startsWith(_LOCALHOST);
    }

    private void _validate(String targetExtension, String id) {
        if (!Validator.isFileExtension((String)targetExtension)) {
            throw new SystemException("Invalid extension: " + targetExtension);
        }
        if (!Validator.isFileName((String)id)) {
            throw new SystemException("Invalid file name: " + id);
        }
    }

    private static class ConversionsHolder {
        private static final Map<String, String[]> _conversionsMap = new HashMap<String, String[]>();

        private ConversionsHolder() {
        }

        public static String[] getConversions(String extension) {
            return _conversionsMap.get(extension);
        }

        private static void _populateConversionsMap(String documentFamily) {
            Filter filter = new Filter(documentFamily);
            DefaultDocumentFormatRegistry documentFormatRegistry = new DefaultDocumentFormatRegistry();
            String[] sourceExtensions = PropsUtil.getArray((String)"openoffice.conversion.source.extensions", (Filter)filter);
            String[] targetExtensions = PropsUtil.getArray((String)"openoffice.conversion.target.extensions", (Filter)filter);
            for (String sourceExtension : sourceExtensions) {
                DocumentFormat sourceDocumentFormat = documentFormatRegistry.getFormatByFileExtension(sourceExtension);
                if (sourceDocumentFormat == null) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)("Invalid source extension " + sourceExtension));
                    continue;
                }
                SortedArrayList conversions = new SortedArrayList();
                for (String targetExtension : targetExtensions) {
                    DocumentFormat targetDocumentFormat = documentFormatRegistry.getFormatByFileExtension(targetExtension);
                    if (targetDocumentFormat == null) {
                        if (!_log.isWarnEnabled()) continue;
                        _log.warn((Object)("Invalid target extension " + targetDocumentFormat));
                        continue;
                    }
                    if (!sourceDocumentFormat.isExportableTo(targetDocumentFormat)) continue;
                    conversions.add(targetExtension);
                }
                if (conversions.isEmpty()) {
                    if (!_log.isInfoEnabled()) continue;
                    _log.info((Object)("There are no conversions supported from " + sourceExtension));
                    continue;
                }
                if (_log.isInfoEnabled()) {
                    _log.info((Object)StringBundler.concat((Object[])new Object[]{"Conversions supported from ", sourceExtension, " to ", conversions}));
                }
                _conversionsMap.put(sourceExtension, conversions.toArray(new String[0]));
            }
        }

        static {
            ConversionsHolder._populateConversionsMap("drawing");
            ConversionsHolder._populateConversionsMap("presentation");
            ConversionsHolder._populateConversionsMap("spreadsheet");
            ConversionsHolder._populateConversionsMap("text");
        }
    }
}

