<%--
/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */
--%>

<%@ include file="/dynamic_include/init.jsp" %>

<script data-senna-track="temporary" type="text/javascript">
	if (window.Analytics) {
		window.<%= DocumentLibraryAnalyticsConstants.JS_PREFIX %>isViewFileEntry = false;
	}
</script>

<aui:script require="metal-dom/src/all/dom as dom,metal-uri/src/Uri" sandbox="<%= true %>">
	var Uri = metalUriSrcUri.default;
	var pathnameRegexp = /\/documents\/(\d+)\/(\d+)\/(.+)\/(.+)/;

	var downloadClickHandler = dom.delegate(
		document.body,
		'click',
		'a',
		function(event) {
			if (window.Analytics) {
				var anchor = event.delegateTarget;
				var uri = new Uri(anchor.href);

				var match = pathnameRegexp.exec(uri.getPathname());

				if (match) {
					Analytics.send(
						'documentDownloaded',
						'Document',
						{
							groupId: match[1],
							fileEntryUUID: match[4],
							preview: !!window.<%= DocumentLibraryAnalyticsConstants.JS_PREFIX %>isViewFileEntry,
							title: decodeURIComponent(match[3].replace(/\+/ig, ' ')),
							version: uri.getParameterValue('version')
						}
					);
				}
			}
		}
	);

	var onDestroyPortlet = function() {
		downloadClickHandler.removeListener()
		Liferay.detach('destroyPortlet', onDestroyPortlet);
	}

	Liferay.on('destroyPortlet', onDestroyPortlet);
</aui:script>