/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.data.engine.model.impl;

import com.liferay.data.engine.model.DEDataDefinitionFieldLink;
import com.liferay.data.engine.service.DEDataDefinitionFieldLinkLocalServiceUtil;

/**
 * The extended model base implementation for the DEDataDefinitionFieldLink service. Represents a row in the &quot;DEDataDefinitionFieldLink&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link DEDataDefinitionFieldLinkImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see DEDataDefinitionFieldLinkImpl
 * @see DEDataDefinitionFieldLink
 * @generated
 */
public abstract class DEDataDefinitionFieldLinkBaseImpl
	extends DEDataDefinitionFieldLinkModelImpl
	implements DEDataDefinitionFieldLink {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a de data definition field link model instance should use the <code>DEDataDefinitionFieldLink</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			DEDataDefinitionFieldLinkLocalServiceUtil.
				addDEDataDefinitionFieldLink(this);
		}
		else {
			DEDataDefinitionFieldLinkLocalServiceUtil.
				updateDEDataDefinitionFieldLink(this);
		}
	}

}