/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.internal.search.spi.model.index.contributor;

import com.liferay.data.engine.model.DEDataListView;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"indexer.class.name=com.liferay.data.engine.model.DEDataListView"}, service={ModelDocumentContributor.class})
public class DEDataListViewModelDocumentContributor
implements ModelDocumentContributor<DEDataListView> {
    @Reference
    private Localization _localization;

    public void contribute(Document document, DEDataListView deDataListView) {
        String[] languageIds;
        document.addKeyword("ddmStructureId", deDataListView.getDdmStructureId());
        for (String languageId : languageIds = this._getLanguageIds(deDataListView.getDefaultLanguageId(), deDataListView.getName())) {
            document.addText(this._localization.getLocalizedName("name", languageId), deDataListView.getName(languageId));
        }
        document.addLocalizedKeyword("localized_name", this._localization.populateLocalizationMap(deDataListView.getNameMap(), deDataListView.getDefaultLanguageId(), deDataListView.getGroupId()), true, true);
    }

    private String[] _getLanguageIds(String defaultLanguageId, String content) {
        String[] languageIds = this._localization.getAvailableLanguageIds(content);
        if (languageIds.length == 0) {
            languageIds = new String[]{defaultLanguageId};
        }
        return languageIds;
    }
}

