/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.cleanup.internal.upgrade;

import com.liferay.data.cleanup.internal.upgrade.BaseUpgradeProcess;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.layout.manager.ContentManager;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructure;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructureRel;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureLocalService;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureRelLocalService;
import com.liferay.layout.service.LayoutClassedModelUsageLocalService;
import com.liferay.petra.function.UnsafeBiConsumer;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LayoutClassedModelUsageOrphanDataUpgradeProcess
extends BaseUpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(LayoutClassedModelUsageOrphanDataUpgradeProcess.class);
    private final ClassNameLocalService _classNameLocalService;
    private final ContentManager _contentManager;
    private final FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    private final LayoutClassedModelUsageLocalService _layoutClassedModelUsageLocalService;
    private final LayoutPageTemplateStructureLocalService _layoutPageTemplateStructureLocalService;
    private final LayoutPageTemplateStructureRelLocalService _layoutPageTemplateStructureRelLocalService;

    public LayoutClassedModelUsageOrphanDataUpgradeProcess(ClassNameLocalService classNameLocalService, ContentManager contentManager, FragmentEntryLinkLocalService fragmentEntryLinkLocalService, LayoutClassedModelUsageLocalService layoutClassedModelUsageLocalService, LayoutPageTemplateStructureLocalService layoutPageTemplateStructureLocalService, LayoutPageTemplateStructureRelLocalService layoutPageTemplateStructureRelLocalService) {
        this._classNameLocalService = classNameLocalService;
        this._contentManager = contentManager;
        this._fragmentEntryLinkLocalService = fragmentEntryLinkLocalService;
        this._layoutClassedModelUsageLocalService = layoutClassedModelUsageLocalService;
        this._layoutPageTemplateStructureLocalService = layoutPageTemplateStructureLocalService;
        this._layoutPageTemplateStructureRelLocalService = layoutPageTemplateStructureRelLocalService;
    }

    protected void doUpgrade() throws Exception {
        this._cleanUpdateLayoutClassedModelUsages();
    }

    private void _cleanUpdateLayoutClassedModelUsages() throws Exception {
        this._processLayoutClassedModelUsage(this._classNameLocalService.getClassNameId(FragmentEntryLink.class.getName()), "fragmentEntryLinkId", "FragmentEntryLink", (UnsafeBiConsumer<Long, Long, Exception>)((UnsafeBiConsumer)this::_updateFragmentEntryLayoutClassedModelUsage));
        this._processLayoutClassedModelUsage(this._classNameLocalService.getClassNameId(LayoutPageTemplateStructure.class.getName()), "layoutPageTemplateStructureId", "LayoutPageTemplateStructure", (UnsafeBiConsumer<Long, Long, Exception>)((UnsafeBiConsumer)this::_updateLayoutPageTemplateStructureClassedModelUsage));
    }

    private void _processLayoutClassedModelUsage(long classNameId, String keyColumnName, String tableName, UnsafeBiConsumer<Long, Long, Exception> unsafeBiConsumer) throws Exception {
        HashMap<Long, Map<Long, Set<Long>>> groupIdMap;
        block16: {
            groupIdMap = new HashMap<Long, Map<Long, Set<Long>>>();
            try (PreparedStatement preparedStatement = this.connection.prepareStatement(SQLTransformer.transform((String)StringBundler.concat((String[])new String[]{"select ctCollectionId, layoutClassedModelUsageId, ", "groupId, plid from LayoutClassedModelUsage where ", "containerType = ? and (plid <> (select plid from ", tableName, " where ", keyColumnName, " = CAST_LONG(containerKey) and ", "LayoutClassedModelUsage.ctCollectionId = ", tableName, ".ctCollectionId) or (not exists (select 1 from ", tableName, " where ", keyColumnName, " = CAST_LONG(containerKey) and ", "LayoutClassedModelUsage.ctCollectionId = ", tableName, ".ctCollectionId)))"})));){
                preparedStatement.setLong(1, classNameId);
                ResultSet resultSet = preparedStatement.executeQuery();
                block12: while (true) {
                    while (resultSet.next()) {
                        long ctCollectionId = resultSet.getLong("ctCollectionId");
                        long layoutClassedModelUsageId = resultSet.getLong("layoutClassedModelUsageId");
                        long groupId = resultSet.getLong("groupId");
                        long plid = resultSet.getLong("plid");
                        try {
                            Map ctCollectionIdMap = groupIdMap.computeIfAbsent(groupId, key -> new HashMap());
                            Set plids = ctCollectionIdMap.computeIfAbsent(ctCollectionId, key -> new HashSet());
                            plids.add(plid);
                            this._layoutClassedModelUsageLocalService.deleteLayoutClassedModelUsage(layoutClassedModelUsageId);
                            continue block12;
                        }
                        catch (Exception exception) {
                            if (!_log.isWarnEnabled()) continue;
                            _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to delete orphaned layout classed ", "model usage with ID ", layoutClassedModelUsageId}), (Throwable)exception);
                        }
                    }
                    break block16;
                    {
                        continue block12;
                        break;
                    }
                    break;
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
        }
        this._processLayoutClassedModelUsage(groupIdMap, unsafeBiConsumer);
    }

    private void _processLayoutClassedModelUsage(Map<Long, Map<Long, Set<Long>>> plidMap, UnsafeBiConsumer<Long, Long, Exception> unsafeBiConsumer) {
        for (Map.Entry<Long, Map<Long, Set<Long>>> groupIdEntry : plidMap.entrySet()) {
            long groupId = groupIdEntry.getKey();
            Map<Long, Set<Long>> ctCollectionIdMap = groupIdEntry.getValue();
            for (Map.Entry<Long, Set<Long>> ctCollectionIdEntry : ctCollectionIdMap.entrySet()) {
                long ctCollectionId = ctCollectionIdEntry.getKey();
                Set<Long> plids = ctCollectionIdEntry.getValue();
                for (long plid : plids) {
                    try {
                        SafeCloseable safeCloseable = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable((long)ctCollectionId);
                        try {
                            unsafeBiConsumer.accept((Object)groupId, (Object)plid);
                        }
                        finally {
                            if (safeCloseable == null) continue;
                            safeCloseable.close();
                        }
                    }
                    catch (Exception exception) {
                        if (!_log.isWarnEnabled()) continue;
                        _log.warn((Throwable)exception);
                    }
                }
            }
        }
    }

    private void _updateFragmentEntryLayoutClassedModelUsage(long groupId, long plid) {
        List fragmentEntryLinks = this._fragmentEntryLinkLocalService.getFragmentEntryLinksByPlid(groupId, plid);
        for (FragmentEntryLink fragmentEntryLink : fragmentEntryLinks) {
            if (fragmentEntryLink == null) continue;
            try {
                this._contentManager.updateLayoutClassedModelUsage(fragmentEntryLink);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to update usages for fragment entry link ", "ID ", fragmentEntryLink.getFragmentEntryId()}), (Throwable)exception);
            }
        }
    }

    private void _updateLayoutPageTemplateStructureClassedModelUsage(long groupId, long plid) {
        LayoutPageTemplateStructure layoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(groupId, plid);
        if (layoutPageTemplateStructure == null) {
            return;
        }
        List layoutPageTemplateStructureRels = this._layoutPageTemplateStructureRelLocalService.getLayoutPageTemplateStructureRels(layoutPageTemplateStructure.getLayoutPageTemplateStructureId());
        for (LayoutPageTemplateStructureRel layoutPageTemplateStructureRel : layoutPageTemplateStructureRels) {
            if (layoutPageTemplateStructureRel == null) continue;
            try {
                this._contentManager.updateLayoutClassedModelUsage(layoutPageTemplateStructureRel);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to update usages for layout page template ", "structure rel ID ", layoutPageTemplateStructureRel.getLayoutPageTemplateStructureRelId()}), (Throwable)exception);
            }
        }
    }
}

