/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.cleanup.internal.verify;

import com.liferay.data.cleanup.internal.verify.ClassNamePostUpgradeDataCleanupProcess;
import com.liferay.data.cleanup.internal.verify.PostUpgradeDataCleanupProcess;
import com.liferay.data.cleanup.internal.verify.ResourceActionPostUpgradeDataCleanupProcess;
import com.liferay.data.cleanup.internal.verify.ServiceComponentPostUpgradeDataCleanupProcess;
import com.liferay.portal.kernel.dependency.manager.DependencyManagerSyncUtil;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ServiceComponentLocalService;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.tools.DBUpgrader;
import com.liferay.portal.verify.VerifyException;
import com.liferay.portal.verify.VerifyProcess;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"run.on.portal.upgrade=true"}, service={VerifyProcess.class})
public class PostUpgradeDataCleanupVerifyProcess
extends VerifyProcess {
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference(target="(module.service.lifecycle=portlets.initialized)")
    private ModuleServiceLifecycle _moduleServiceLifecycle;
    @Reference
    private ResourceActionLocalService _resourceActionLocalService;
    @Reference
    private ServiceComponentLocalService _serviceComponentLocalService;

    public void verify() throws VerifyException {
        DependencyManagerSyncUtil.registerSyncCallable(() -> {
            try {
                super.verify();
            }
            finally {
                DBUpgrader.stopUpgradeLogAppender();
            }
            return null;
        });
    }

    protected void doVerify() throws Exception {
        for (PostUpgradeDataCleanupProcess postUpgradeDataCleanupProcess : this._getPostUpgradeDataCleanupProcesses()) {
            try (LoggingTimer loggingTimer = new LoggingTimer(ClassUtil.getClassName((Object)postUpgradeDataCleanupProcess));){
                postUpgradeDataCleanupProcess.cleanUp();
            }
        }
    }

    private List<PostUpgradeDataCleanupProcess> _getPostUpgradeDataCleanupProcesses() {
        return ListUtil.fromArray((Object[])new PostUpgradeDataCleanupProcess[]{new ClassNamePostUpgradeDataCleanupProcess(this._classNameLocalService, this.connection), new ResourceActionPostUpgradeDataCleanupProcess(this.connection, this._resourceActionLocalService), new ServiceComponentPostUpgradeDataCleanupProcess(this.connection, this._serviceComponentLocalService)});
    }
}

