/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.cleanup.internal.verify;

import com.liferay.data.cleanup.internal.verify.PostUpgradeDataCleanupProcess;
import com.liferay.data.cleanup.internal.verify.util.PostUpgradeDataCleanupProcessUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.kernel.dao.db.DBInspector;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.data.cleanup.DataCleanupPreupgradeProcess;
import com.liferay.portal.kernel.upgrade.data.cleanup.TableOrphanReferencesDataCleanupPreupgradeProcess;
import com.liferay.portal.kernel.upgrade.data.cleanup.util.DataCleanupLoggingUtil;
import com.liferay.portal.upgrade.data.cleanup.PortletPreferencesDataCleanupPreupgradeProcess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashSet;
import java.util.Set;

public class PortletPreferencesPostUpgradeDataCleanupProcess
implements PostUpgradeDataCleanupProcess {
    private static final Log _log = LogFactoryUtil.getLog(PortletPreferencesPostUpgradeDataCleanupProcess.class);
    private final Connection _connection;
    private final DBInspector _dbInspector;
    private final boolean _deletePortlets;
    private final PortletLocalService _portletLocalService;

    public PortletPreferencesPostUpgradeDataCleanupProcess(Connection connection, boolean deletePortlets, PortletLocalService portletLocalService) {
        this._connection = connection;
        this._deletePortlets = deletePortlets;
        this._portletLocalService = portletLocalService;
        this._dbInspector = new DBInspector(connection);
    }

    @Override
    public void cleanUp() throws Exception {
        if (!PostUpgradeDataCleanupProcessUtil.isEveryLiferayBundleResolved()) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((String[])new String[]{PortletPreferencesPostUpgradeDataCleanupProcess.class.getSimpleName(), " cannot be executed because there are modules with ", "unsatisfied references"}));
            }
            return;
        }
        HashSet<String> portletIds = new HashSet<String>();
        for (Portlet portlet : PortletLocalServiceUtil.getPortlets()) {
            portletIds.add(portlet.getPortletId());
        }
        try (PreparedStatement preparedStatement = this._connection.prepareStatement("select id_, portletId from Portlet");
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                String portletId = resultSet.getString(2);
                if (!portletId.startsWith("com.liferay.") && !portletId.startsWith("com_liferay_") || portletIds.contains(portletId)) continue;
                if (this._deletePortlets) {
                    long id_ = resultSet.getLong(1);
                    this._portletLocalService.deletePortlet(id_);
                }
                DataCleanupLoggingUtil.logDelete((Log)_log, (long)1L, (!this._deletePortlets ? 1 : 0) != 0, (String)this._dbInspector.normalizeName("Portlet"), (String)StringBundler.concat((String[])new String[]{"\"", portletId, "\" is not installed"}));
            }
        }
        PortletUpgradeProcess upgradeProcess = new PortletUpgradeProcess(portletIds, !this._deletePortlets);
        upgradeProcess.upgrade();
        if (this._deletePortlets) {
            upgradeProcess = new PortletPreferencesDataCleanupPreupgradeProcess();
            upgradeProcess.upgrade();
        }
    }

    private static class PortletUpgradeProcess
    extends DataCleanupPreupgradeProcess {
        private static final String _TEMP_TABLE_NAME = "TEMP_TABLE_PORTLET";
        private final Set<String> _portletIds;
        private final boolean _readOnly;

        public PortletUpgradeProcess(Set<String> portletIds, boolean readOnly) {
            this._portletIds = portletIds;
            this._readOnly = readOnly;
        }

        protected void doUpgrade() throws Exception {
            if (!this.hasTable(_TEMP_TABLE_NAME)) {
                this.runSQL("create table TEMP_TABLE_PORTLET (portletId VARCHAR(200))");
            }
            try (PreparedStatement preparedStatement = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"insert into TEMP_TABLE_PORTLET (portletId) values (?)");){
                for (String portletId : this._portletIds) {
                    preparedStatement.setString(1, portletId);
                    preparedStatement.addBatch();
                }
                preparedStatement.executeBatch();
            }
            this.upgrade((UpgradeProcess)new TableOrphanReferencesDataCleanupPreupgradeProcess(SQLTransformer.transform((String)StringBundler.concat((String[])new String[]{"CASE WHEN INSTR([$SOURCE_TABLE_ALIAS$].", "portletId, '_INSTANCE_') > 0 THEN SUBSTR(", "[$SOURCE_TABLE_ALIAS$].portletId, 1, INSTR(", "[$SOURCE_TABLE_ALIAS$].portletId, '_INSTANCE_') ", "- 1) ELSE [$SOURCE_TABLE_ALIAS$].portletId END ", "or [$TARGET_TABLE_ALIAS$].portletId = CASE WHEN ", "INSTR([$SOURCE_TABLE_ALIAS$].portletId, '_USER_'", ") > 0 THEN SUBSTR([$SOURCE_TABLE_ALIAS$].", "portletId, 1, INSTR([$SOURCE_TABLE_ALIAS$].", "portletId, '_USER_') - 1) ELSE ", "[$SOURCE_TABLE_ALIAS$].portletId END"})), this._readOnly, "[$SOURCE_TABLE_ALIAS$].ownerType = 3", "portletId", "PortletPreferences", "portletId", _TEMP_TABLE_NAME));
            this.runSQL("DROP_TABLE_IF_EXISTS(TEMP_TABLE_PORTLET)");
        }
    }
}

