/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.cleanup.internal.verify;

import com.liferay.data.cleanup.internal.verify.PostUpgradeDataCleanupProcess;
import com.liferay.data.cleanup.internal.verify.util.PostUpgradeDataCleanupProcessUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.dao.db.BaseDBProcess;
import com.liferay.portal.kernel.dao.db.DBInspector;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.upgrade.data.cleanup.util.DataCleanupLoggingUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ClassNamePostUpgradeDataCleanupProcess
extends BaseDBProcess
implements PostUpgradeDataCleanupProcess {
    private static final Log _log = LogFactoryUtil.getLog(ClassNamePostUpgradeDataCleanupProcess.class);
    private final ClassNameLocalService _classNameLocalService;

    public ClassNamePostUpgradeDataCleanupProcess(ClassNameLocalService classNameLocalService, Connection connection) {
        this._classNameLocalService = classNameLocalService;
        this.connection = connection;
    }

    @Override
    public void cleanUp() throws Exception {
        if (!PostUpgradeDataCleanupProcessUtil.isEveryLiferayBundleResolved()) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((String[])new String[]{ClassNamePostUpgradeDataCleanupProcess.class.getSimpleName(), " cannot be executed because there are modules with ", "unsatisfied references"}));
            }
            return;
        }
        BundleContext bundleContext = SystemBundleUtil.getBundleContext();
        List classNames = this._classNameLocalService.getClassNames(-1, -1);
        DBInspector dbInspector = new DBInspector(this.connection);
        HashSet models = new HashSet(ModelHintsUtil.getModels());
        ArrayList<String> tableNames = new ArrayList<String>();
        for (String tableName : dbInspector.getTableNames(null)) {
            if (!dbInspector.hasColumn(tableName, "classNameId") || StringUtil.equalsIgnoreCase((String)tableName, (String)"ClassName_")) continue;
            tableNames.add(tableName);
        }
        this.processConcurrently(classNames.toArray(new ClassName[0]), className -> {
            String value = className.getValue();
            if (!value.startsWith("com.liferay.")) {
                return;
            }
            int dashIndex = value.indexOf("-");
            int poundIndex = value.indexOf("#");
            if (dashIndex != -1) {
                value = value.substring(0, dashIndex);
            }
            if (poundIndex != -1) {
                value = value.substring(0, poundIndex);
            }
            if (models.contains(value)) {
                return;
            }
            Class clazz = null;
            for (Bundle bundle : bundleContext.getBundles()) {
                try {
                    clazz = bundle.loadClass(value);
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Throwable)classNotFoundException);
                }
            }
            if (clazz != null) {
                return;
            }
            HashSet<String> usedTableNames = new HashSet<String>();
            for (String tableName : tableNames) {
                PreparedStatement preparedStatement = this.connection.prepareStatement("select 1 from " + tableName + " where classNameId = ?");
                try {
                    preparedStatement.setLong(1, className.getClassNameId());
                    ResultSet resultSet = preparedStatement.executeQuery();
                    try {
                        if (!resultSet.next()) continue;
                        usedTableNames.add(tableName);
                    }
                    finally {
                        if (resultSet == null) continue;
                        resultSet.close();
                    }
                }
                finally {
                    if (preparedStatement == null) continue;
                    preparedStatement.close();
                }
            }
            if (usedTableNames.isEmpty()) {
                this._classNameLocalService.deleteClassName(className);
                DataCleanupLoggingUtil.logDelete((Log)_log, (long)1L, (String)dbInspector.normalizeName("ClassName_"), (String)StringBundler.concat((String[])new String[]{"\"", value, "\" is not defined in any deployed module and is ", "not in use"}));
            } else if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((String[])new String[]{"Class name ", value, " is not defined in any deployed module but is ", "referenced in the next tables: ", String.join((CharSequence)", ", new TreeSet(usedTableNames))}));
            }
        }, null);
    }
}

