/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.cleanup.internal.upgrade.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LayoutTypeSettingsUtil {
    public static void removePortletIds(Connection connection, String ... portletIds) throws Exception {
        if (portletIds == null) {
            return;
        }
        try (PreparedStatement updatePreparedStatement = AutoBatchPreparedStatementUtil.autoBatch((Connection)connection, (String)"update Layout set typeSettings = ? where plid = ?");){
            for (String portletId : portletIds) {
                try (PreparedStatement selectPreparedStatement = connection.prepareStatement(StringBundler.concat((String[])new String[]{"select plid, typeSettings from Layout where ", "typeSettings like '%", portletId, "%'"}));
                     ResultSet resultSet = selectPreparedStatement.executeQuery();){
                    while (resultSet.next()) {
                        LayoutTypeSettingsUtil._removePortletId(portletId, resultSet, updatePreparedStatement);
                    }
                }
                updatePreparedStatement.executeBatch();
            }
        }
    }

    private static void _removePortletId(String portletId, ResultSet resultSet, PreparedStatement updatePreparedStatement) throws Exception {
        String typeSettings = resultSet.getString(2);
        UnicodeProperties unicodeProperties = UnicodePropertiesBuilder.create((boolean)true).fastLoad(typeSettings).build();
        Set entries = unicodeProperties.entrySet();
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String value = (String)entry.getValue();
            if (!value.contains(portletId)) continue;
            List parts = StringUtil.split((String)value, (char)',');
            if (parts.size() <= 1) {
                iterator.remove();
                continue;
            }
            StringBundler sb = new StringBundler(2 * parts.size() - 2);
            for (String part : parts) {
                if (part.startsWith(portletId)) continue;
                sb.append(part);
                sb.append(",");
            }
            if (sb.index() == 0) {
                iterator.remove();
                continue;
            }
            sb.setIndex(sb.index() - 1);
            entry.setValue(sb.toString());
        }
        updatePreparedStatement.setString(1, unicodeProperties.toString());
        long plid = resultSet.getLong(1);
        updatePreparedStatement.setLong(2, plid);
        updatePreparedStatement.addBatch();
    }
}

