/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.cleanup.internal.upgrade;

import com.liferay.data.cleanup.internal.upgrade.BaseUpgradeProcess;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.kernel.service.ImageLocalService;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class ShoppingUpgradeProcess
extends BaseUpgradeProcess {
    private final ImageLocalService _imageLocalService;

    public ShoppingUpgradeProcess(ImageLocalService imageLocalService) {
        this._imageLocalService = imageLocalService;
    }

    protected void doUpgrade() throws Exception {
        this._deleteFromShoppingItem("smallImage");
        this._deleteFromShoppingItem("mediumImage");
        this._deleteFromShoppingItem("largeImage");
        this.removePortletData(new String[]{"com.liferay.shopping.web"}, new String[]{"34"}, new String[]{"com_liferay_shopping_web_portlet_ShoppingPortlet", "com.liferay.portlet.shopping"});
        this.removeServiceData("Shopping", new String[]{"com.liferay.shopping.service"}, new String[]{"com.liferay.portlet.shopping", "com.liferay.portlet.shopping.model.ShoppingCart", "com.liferay.portlet.shopping.model.ShoppingCategory", "com.liferay.portlet.shopping.model.ShoppingCoupon", "com.liferay.portlet.shopping.model.ShoppingItem", "com.liferay.portlet.shopping.model.ShoppingItemField", "com.liferay.portlet.shopping.model.ShoppingItemPrice", "com.liferay.portlet.shopping.model.ShoppingOrder", "com.liferay.portlet.shopping.model.ShoppingOrderItem", "com.liferay.shopping.model.ShoppingCart", "com.liferay.shopping.model.ShoppingCategory", "com.liferay.shopping.model.ShoppingCoupon", "com.liferay.shopping.model.ShoppingItem", "com.liferay.shopping.model.ShoppingItemField", "com.liferay.shopping.model.ShoppingItemPrice", "com.liferay.shopping.model.ShoppingOrder", "com.liferay.shopping.model.ShoppingOrderItem"}, new String[]{"ShoppingCart", "ShoppingCategory", "ShoppingCoupon", "ShoppingItem", "ShoppingItemField", "ShoppingItemPrice", "ShoppingOrder", "ShoppingOrderItem"});
    }

    private void _deleteFromShoppingItem(String type) throws Exception {
        if (!this.hasTable("ShoppingItem")) {
            return;
        }
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(SQLTransformer.transform((String)StringBundler.concat((String[])new String[]{"select ", type, "Id from ShoppingItem where ", type, " = [$TRUE$]"})));
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                this._imageLocalService.deleteImage(resultSet.getLong(1));
            }
        }
    }
}

