/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.cleanup.internal;

import com.liferay.change.tracking.service.CTCollectionLocalService;
import com.liferay.change.tracking.service.CTEntryLocalService;
import com.liferay.change.tracking.store.service.CTSContentLocalService;
import com.liferay.data.cleanup.DataCleanup;
import com.liferay.data.cleanup.DataCleanupAdapter;
import com.liferay.data.cleanup.internal.upgrade.AmazonRankingsUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.ChatUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.CurrencyConverterUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.DLPreviewCTSContentDataUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.DictionaryUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.DirectoryUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.DocumentLibraryFileRankServiceUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.ExpiredJournalArticleUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.FrontendImageEditorUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.GoogleMapsUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.HTMLPreviewUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.HelloVelocityUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.InvitationUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.LayoutClassedModelUsageOrphanDataUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.LoanCalculatorUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.MailReaderUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.NetworkUtilitiesUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.OAuthUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.OpenSocialUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.OutdatedPublishedCTCollectionUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.PasswordGeneratorUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.PortalSecurityWedeployAuthUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.PublishedCTSContentDataUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.QuickNoteUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.RecentDocumentsUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.ShoppingUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.SocialActivityUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.SocialGroupStatisticsUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.SocialPrivateMessagingUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.SocialRequestsUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.SocialUserStatisticsUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.SoftwareCatalogUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.SyncUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.TranslatorUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.TwitterUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.UnitConverterUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.UpgradeHelloWorld;
import com.liferay.data.cleanup.internal.upgrade.WeatherUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.WebFormUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.WebProxyUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.WidgetLayoutTypeSettingsUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.WysiwygUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.XSLContentUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.YoutubeUpgradeProcess;
import com.liferay.data.cleanup.internal.verify.ClassNamePostUpgradeDataCleanupProcess;
import com.liferay.data.cleanup.internal.verify.PortletPreferencesPostUpgradeDataCleanupProcess;
import com.liferay.data.cleanup.internal.verify.ResourceActionPostUpgradeDataCleanupProcess;
import com.liferay.data.cleanup.internal.verify.ServiceComponentPostUpgradeDataCleanupProcess;
import com.liferay.data.cleanup.util.DataCleanupUtil;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.layout.manager.ContentManager;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureLocalService;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureRelLocalService;
import com.liferay.layout.service.LayoutClassedModelUsageLocalService;
import com.liferay.message.boards.service.MBMessageLocalService;
import com.liferay.message.boards.service.MBThreadLocalService;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ImageLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ServiceComponentLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.data.cleanup.DataCleanupPreupgradeProcess;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.upgrade.data.cleanup.AnalyticsMessageDataCleanupPreupgradeProcess;
import com.liferay.portal.upgrade.data.cleanup.CompanyDataCleanupPreupgradeProcess;
import com.liferay.portal.upgrade.data.cleanup.ConfigurationDataCleanupPreupgradeProcess;
import com.liferay.portal.upgrade.data.cleanup.CounterDataCleanupPreupgradeProcess;
import com.liferay.portal.upgrade.data.cleanup.DDMDataCleanupPreupgradeProcess;
import com.liferay.portal.upgrade.data.cleanup.DDMStorageLinkDataCleanupPreupgradeProcess;
import com.liferay.portal.upgrade.data.cleanup.DLFileEntryDataCleanupPreupgradeProcess;
import com.liferay.portal.upgrade.data.cleanup.DataCleanupPreupgradeProcessSuite;
import com.liferay.portal.upgrade.data.cleanup.GroupDataCleanupPreupgradeProcess;
import com.liferay.portal.upgrade.data.cleanup.JournalDataCleanupPreupgradeProcess;
import com.liferay.portal.upgrade.data.cleanup.NullUnicodeContentDataCleanupPreupgradeProcess;
import com.liferay.portal.upgrade.data.cleanup.PortalPreferencesDataCleanupPreupgradeProcess;
import com.liferay.portal.upgrade.data.cleanup.QuartzJobDetailsDataCleanupPreupgradeProcess;
import com.liferay.portal.upgrade.data.cleanup.UserDataCleanupPreupgradeProcess;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.ratings.kernel.service.RatingsStatsLocalService;
import com.liferay.subscription.service.SubscriptionLocalService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={})
public class DataCleanupRegistrator {
    private static final Map<Class<?>, String> _dataCleanupLabels = HashMapBuilder.put(AnalyticsMessageDataCleanupPreupgradeProcess.class, (Object)"remove-analytics-message-data").put(CompanyDataCleanupPreupgradeProcess.class, (Object)"remove-company-orphan-data").put(ConfigurationDataCleanupPreupgradeProcess.class, (Object)"remove-configuration-orphan-data").put(CounterDataCleanupPreupgradeProcess.class, (Object)"fix-counter-values").put(DDMDataCleanupPreupgradeProcess.class, (Object)"remove-ddm-orphan-data").put(DDMStorageLinkDataCleanupPreupgradeProcess.class, (Object)"remove-ddm-storage-link-orphan-data").put(DLFileEntryDataCleanupPreupgradeProcess.class, (Object)"remove-dl-file-entry-orphan-data").put(GroupDataCleanupPreupgradeProcess.class, (Object)"remove-group-orphan-data").put(JournalDataCleanupPreupgradeProcess.class, (Object)"remove-journal-orphan-data").put(NullUnicodeContentDataCleanupPreupgradeProcess.class, (Object)"remove-null-unicode-content-data").put(PortalPreferencesDataCleanupPreupgradeProcess.class, (Object)"remove-portal-preferences-orphan-data").put(QuartzJobDetailsDataCleanupPreupgradeProcess.class, (Object)"remove-quartz-job-details-data").put(UserDataCleanupPreupgradeProcess.class, (Object)"remove-user-orphan-data").build();
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private ContentManager _contentManager;
    @Reference
    private CTCollectionLocalService _ctCollectionLocalService;
    @Reference
    private CTEntryLocalService _ctEntryLocalService;
    @Reference
    private CTSContentLocalService _ctsContentLocalService;
    private final List<DataCleanup> _dataCleanups = new ArrayList<DataCleanup>();
    @Reference
    private ExpandoTableLocalService _expandoTableLocalService;
    @Reference
    private FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    @Reference
    private ImageLocalService _imageLocalService;
    @Reference
    private JournalArticleLocalService _journalArticleLocalService;
    @Reference
    private LayoutClassedModelUsageLocalService _layoutClassedModelUsageLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateStructureLocalService _layoutPageTemplateStructureLocalService;
    @Reference
    private LayoutPageTemplateStructureRelLocalService _layoutPageTemplateStructureRelLocalService;
    @Reference
    private MBMessageLocalService _mbMessageLocalService;
    @Reference
    private MBThreadLocalService _mbThreadLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private PortletLocalService _portletLocalService;
    @Reference
    private RatingsStatsLocalService _ratingsStatsLocalService;
    @Reference
    private ResourceActionLocalService _resourceActionLocalService;
    @Reference
    private ServiceComponentLocalService _serviceComponentLocalService;
    @Reference
    private SubscriptionLocalService _subscriptionLocalService;

    @Activate
    protected void activate() throws Exception {
        this._registerModuleDataCleanups();
        this._registerSystemDataCleanups();
    }

    @Deactivate
    protected void deactivate() throws Exception {
        for (DataCleanup dataCleanup : this._dataCleanups) {
            DataCleanupUtil.unregisterDataCleanup((DataCleanup)dataCleanup);
        }
    }

    private String _getBundleSymbolicName(Class<?> clazz) {
        Bundle bundle = FrameworkUtil.getBundle(clazz);
        if (bundle == null) {
            return null;
        }
        return bundle.getSymbolicName();
    }

    private String _getDataCleanupLabel(DataCleanupPreupgradeProcess dataCleanupPreupgradeProcess) {
        return _dataCleanupLabels.get(dataCleanupPreupgradeProcess.getClass());
    }

    private void _registerDataCleanup(DataCleanup dataCleanup) {
        this._dataCleanups.add(dataCleanup);
        DataCleanupUtil.registerDataCleanup((DataCleanup)dataCleanup);
    }

    private void _registerModuleDataCleanups() {
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-module-data-help", (String)"clean-up-amazon-rankings-module-data", (String)"com.liferay.amazon.rankings.web", (String)"module", (UpgradeProcess)new AmazonRankingsUpgradeProcess()));
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-module-data-and-tables-help", (String)"clean-up-chat-module-data", (String)"com.liferay.chat.service", (String)"module", (UpgradeProcess)new ChatUpgradeProcess()));
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-module-data-help", (String)"clean-up-currency-converter-module-data", (String)"com.liferay.currency.converter.web", (String)"module", (UpgradeProcess)new CurrencyConverterUpgradeProcess()));
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-module-data-help", (String)"clean-up-dictionary-module-data", (String)"com.liferay.dictionary.web", (String)"module", (UpgradeProcess)new DictionaryUpgradeProcess()));
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-module-data-help", (String)"clean-up-directory-module-data", (String)"com.liferay.directory.web", (String)"module", (UpgradeProcess)new DirectoryUpgradeProcess()));
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-module-data-and-tables-help", (String)"clean-up-document-library-file-rank-module-data", (String)"com.liferay.document.library.file.rank.service", (String)"module", (UpgradeProcess)new DocumentLibraryFileRankServiceUpgradeProcess()));
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-module-data-help", (String)"clean-up-frontend-image-editor-module-data", (String)"com.liferay.frontend.image.editor.web", (String)"module", (UpgradeProcess)new FrontendImageEditorUpgradeProcess()));
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-module-data-help", (String)"clean-up-google-maps-module-data", (String)"com.liferay.google.maps.web", (String)"module", (UpgradeProcess)new GoogleMapsUpgradeProcess()));
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-module-data-help", (String)"clean-up-hello-velocity-module-data", (String)"com.liferay.hello.velocity.web", (String)"module", (UpgradeProcess)new HelloVelocityUpgradeProcess()));
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-module-data-help", (String)"clean-up-hello-world-module-data", (String)"com.liferay.hello.world.web", (String)"module", (UpgradeProcess)new UpgradeHelloWorld()));
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-module-data-and-tables-help", (String)"clean-up-html-preview-module-data", (String)"com.liferay.html.preview.service", (String)"module", (UpgradeProcess)new HTMLPreviewUpgradeProcess()));
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-module-data-help", (String)"clean-up-invitation-module-data", (String)"com.liferay.invitation.web", (String)"module", (UpgradeProcess)new InvitationUpgradeProcess()));
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-module-data-help", (String)"clean-up-loan-calculator-module-data", (String)"com.liferay.loan.calculator.web", (String)"module", (UpgradeProcess)new LoanCalculatorUpgradeProcess()));
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-module-data-and-tables-help", (String)"clean-up-mail-reader-module-data", (String)"com.liferay.mail.reader.service", (String)"module", (UpgradeProcess)new MailReaderUpgradeProcess()));
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-module-data-help", (String)"clean-up-network-utilities-module-data", (String)"com.liferay.network.utilities.web", (String)"module", (UpgradeProcess)new NetworkUtilitiesUpgradeProcess()));
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-module-data-and-tables-help", (String)"clean-up-oauth-module-data", (String)"com.liferay.oauth.service", (String)"module", (UpgradeProcess)new OAuthUpgradeProcess()));
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-module-data-help", (String)"clean-up-password-generator-module-data", (String)"com.liferay.password.generator.web", (String)"module", (UpgradeProcess)new PasswordGeneratorUpgradeProcess()));
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-module-data-and-tables-help", (String)"clean-up-portal-security-wedeploy-auth-module-data", (String)"com.liferay.portal.security.wedeploy.auth.service", (String)"module", (UpgradeProcess)new PortalSecurityWedeployAuthUpgradeProcess()));
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-module-data-help", (String)"clean-up-quick-note-module-data", (String)"com.liferay.quick.note.web", (String)"module", (UpgradeProcess)new QuickNoteUpgradeProcess()));
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-module-data-help", (String)"clean-up-recent-documents-module-data", (String)"com.liferay.recent.documents.web", (String)"module", (UpgradeProcess)new RecentDocumentsUpgradeProcess()));
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-module-data-and-tables-help", (String)"clean-up-shopping-module-data", (String)"com.liferay.shopping.service", (String)"module", (UpgradeProcess)new ShoppingUpgradeProcess(this._imageLocalService)));
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-module-data-help", (String)"clean-up-social-activity-module-data", (String)"com.liferay.social.activity.web", (String)"module", (UpgradeProcess)new SocialActivityUpgradeProcess()));
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-module-data-help", (String)"clean-up-social-group-statistics-module-data", (String)"com.liferay.social.group.statistics.web", (String)"module", (UpgradeProcess)new SocialGroupStatisticsUpgradeProcess()));
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-module-data-and-tables-help", (String)"clean-up-social-private-messaging-module-data", (String)"com.liferay.social.privatemessaging.service", (String)"module", (UpgradeProcess)new SocialPrivateMessagingUpgradeProcess(this._mbThreadLocalService)));
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-module-data-help", (String)"clean-up-social-requests-module-data", (String)"com.liferay.social.requests.web", (String)"module", (UpgradeProcess)new SocialRequestsUpgradeProcess()));
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-module-data-help", (String)"clean-up-social-user-statistics-module-data", (String)"com.liferay.social.user.statistics.web", (String)"module", (UpgradeProcess)new SocialUserStatisticsUpgradeProcess()));
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-module-data-and-tables-help", (String)"clean-up-software-catalog-module-data", (String)"com.liferay.softwarecatalog.service", (String)"module", (UpgradeProcess)new SoftwareCatalogUpgradeProcess(this._imageLocalService, this._mbMessageLocalService, this._ratingsStatsLocalService, this._subscriptionLocalService)));
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-module-data-and-tables-help", (String)"clean-up-sync-module-data", (String)"com.liferay.sync.service", (String)"module", (UpgradeProcess)new SyncUpgradeProcess()));
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-module-data-help", (String)"clean-up-translator-module-data", (String)"com.liferay.translator.web", (String)"module", (UpgradeProcess)new TranslatorUpgradeProcess()));
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-module-data-and-tables-help", (String)"clean-up-twitter-module-data", (String)"com.liferay.twitter.service", (String)"module", (UpgradeProcess)new TwitterUpgradeProcess()));
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-module-data-help", (String)"clean-up-unit-converter-module-data", (String)"com.liferay.unit.converter.web", (String)"module", (UpgradeProcess)new UnitConverterUpgradeProcess()));
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-module-data-help", (String)"clean-up-weather-module-data", (String)"com.liferay.weather.web", (String)"module", (UpgradeProcess)new WeatherUpgradeProcess()));
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-module-data-help", (String)"clean-up-web-form-module-data", (String)"com.liferay.web.form.web", (String)"module", (UpgradeProcess)new WebFormUpgradeProcess()));
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-module-data-help", (String)"clean-up-web-proxy-module-data", (String)"com.liferay.web.proxy.web", (String)"module", (UpgradeProcess)new WebProxyUpgradeProcess()));
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-module-data-help", (String)"clean-up-wysiwyg-module-data", (String)"com.liferay.wysiwyg.web", (String)"module", (UpgradeProcess)new WysiwygUpgradeProcess()));
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-module-data-help", (String)"clean-up-xsl-content-module-data", (String)"com.liferay.xsl.content.web", (String)"module", (UpgradeProcess)new XSLContentUpgradeProcess()));
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-module-data-help", (String)"clean-up-youtube-module-data", (String)"com.liferay.youtube.web", (String)"module", (UpgradeProcess)new YoutubeUpgradeProcess()));
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-module-data-and-tables-help", (String)"clean-up-open-social-module-data", (String)"opensocial-portlet", (String)"module", (UpgradeProcess)new OpenSocialUpgradeProcess(this._expandoTableLocalService)));
    }

    private void _registerSystemDataCleanups() {
        this._registerDataCleanup(DataCleanupAdapter.create((String)"remove-class-name-orphan-data", (String)this._getBundleSymbolicName(ClassNamePostUpgradeDataCleanupProcess.class), (String)"system", (VerifyProcess)new VerifyProcess(){

            protected void doVerify() throws Exception {
                ClassNamePostUpgradeDataCleanupProcess postUpgradeDataCleanupProcess = new ClassNamePostUpgradeDataCleanupProcess(DataCleanupRegistrator.this._classNameLocalService, this.connection);
                postUpgradeDataCleanupProcess.cleanUp();
            }
        }));
        this._registerDataCleanup(DataCleanupAdapter.create((String)"remove-dl-preview-cts-content-data", (String)"com.liferay.change.tracking.service", (String)"system", (UpgradeProcess)new DLPreviewCTSContentDataUpgradeProcess(this._ctCollectionLocalService, this._ctEntryLocalService, this._portal)));
        this._registerDataCleanup(DataCleanupAdapter.create((String)"remove-expired-journal-articles", (String)"com.liferay.journal.service", (String)"system", (UpgradeProcess)new ExpiredJournalArticleUpgradeProcess(this._journalArticleLocalService)));
        this._registerDataCleanup(DataCleanupAdapter.create((String)"remove-layout-classed-model-usage-orphan-data", (String)"com.liferay.layout.service", (String)"system", (UpgradeProcess)new LayoutClassedModelUsageOrphanDataUpgradeProcess(this._classNameLocalService, this._contentManager, this._ctCollectionLocalService, this._fragmentEntryLinkLocalService, this._layoutClassedModelUsageLocalService, this._layoutPageTemplateStructureLocalService, this._layoutPageTemplateStructureRelLocalService)));
        this._registerDataCleanup(DataCleanupAdapter.create((String)"remove-portlet-preferences-orphan-data", (String)this._getBundleSymbolicName(ClassNamePostUpgradeDataCleanupProcess.class), (String)"system", (VerifyProcess)new VerifyProcess(){

            protected void doVerify() throws Exception {
                PortletPreferencesPostUpgradeDataCleanupProcess postUpgradeDataCleanupProcess = new PortletPreferencesPostUpgradeDataCleanupProcess(this.connection, true, DataCleanupRegistrator.this._portletLocalService);
                postUpgradeDataCleanupProcess.cleanUp();
            }
        }));
        this._registerDataCleanup(DataCleanupAdapter.create((String)"remove-publications-older-than-6-months", (String)"com.liferay.change.tracking.service", (String)"system", (UpgradeProcess)new OutdatedPublishedCTCollectionUpgradeProcess(this._ctCollectionLocalService)));
        this._registerDataCleanup(DataCleanupAdapter.create((String)"remove-published-cts-content-data", (String)"com.liferay.change.tracking.store.service", (String)"system", (UpgradeProcess)new PublishedCTSContentDataUpgradeProcess(this._ctsContentLocalService, this._portal)));
        this._registerDataCleanup(DataCleanupAdapter.create((String)"remove-resource-action-orphan-data", (String)this._getBundleSymbolicName(ClassNamePostUpgradeDataCleanupProcess.class), (String)"system", (VerifyProcess)new VerifyProcess(){

            protected void doVerify() throws Exception {
                ResourceActionPostUpgradeDataCleanupProcess postUpgradeDataCleanupProcess = new ResourceActionPostUpgradeDataCleanupProcess(this.connection, DataCleanupRegistrator.this._resourceActionLocalService);
                postUpgradeDataCleanupProcess.cleanUp();
            }
        }));
        this._registerDataCleanup(DataCleanupAdapter.create((String)"remove-service-component-orphan-data", (String)this._getBundleSymbolicName(ClassNamePostUpgradeDataCleanupProcess.class), (String)"system", (VerifyProcess)new VerifyProcess(){

            protected void doVerify() throws Exception {
                ServiceComponentPostUpgradeDataCleanupProcess postUpgradeDataCleanupProcess = new ServiceComponentPostUpgradeDataCleanupProcess(this.connection, DataCleanupRegistrator.this._serviceComponentLocalService);
                postUpgradeDataCleanupProcess.cleanUp();
            }
        }));
        this._registerDataCleanup(DataCleanupAdapter.create((String)"remove-widget-layout-type-settings", (String)"com.liferay.layout.service", (String)"system", (UpgradeProcess)new WidgetLayoutTypeSettingsUpgradeProcess(this._layoutLocalService)));
        DataCleanupPreupgradeProcessSuite dataCleanupPreupgradeProcessSuite = new DataCleanupPreupgradeProcessSuite();
        for (DataCleanupPreupgradeProcess dataCleanupPreupgradeProcess : dataCleanupPreupgradeProcessSuite.getSortedDataCleanupPreupgradeProcesses()) {
            String dataCleanupLabel = this._getDataCleanupLabel(dataCleanupPreupgradeProcess);
            if (dataCleanupLabel == null) continue;
            this._registerDataCleanup(DataCleanupAdapter.create((String)dataCleanupLabel, (String)"portal", (String)"system", (UpgradeProcess)dataCleanupPreupgradeProcess));
        }
    }
}

