/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.cleanup.internal.verify;

import com.liferay.data.cleanup.internal.verify.PostUpgradeDataCleanupProcess;
import com.liferay.data.cleanup.internal.verify.util.PostUpgradeDataCleanupProcessUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.db.DBInspector;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.upgrade.data.cleanup.util.DataCleanupLoggingUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashSet;
import java.util.List;

public class ResourceActionPostUpgradeDataCleanupProcess
implements PostUpgradeDataCleanupProcess {
    private static final Log _log = LogFactoryUtil.getLog(ResourceActionPostUpgradeDataCleanupProcess.class);
    private final Connection _connection;
    private final DBInspector _dbInspector;
    private final ResourceActionLocalService _resourceActionLocalService;

    public ResourceActionPostUpgradeDataCleanupProcess(Connection connection, ResourceActionLocalService resourceActionLocalService) {
        this._connection = connection;
        this._resourceActionLocalService = resourceActionLocalService;
        this._dbInspector = new DBInspector(connection);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void cleanUp() throws Exception {
        if (!PostUpgradeDataCleanupProcessUtil.isEveryLiferayBundleResolved()) {
            if (!_log.isWarnEnabled()) return;
            _log.warn((Object)StringBundler.concat((String[])new String[]{ResourceActionPostUpgradeDataCleanupProcess.class.getSimpleName(), " cannot be executed because there are modules with ", "unsatisfied references"}));
            return;
        }
        HashSet modelNames = new HashSet(ResourceActionsUtil.getModelNames());
        HashSet portletNames = new HashSet(ResourceActionsUtil.getPortletNames());
        try (PreparedStatement preparedStatement1 = this._connection.prepareStatement("select distinct name from ResourceAction");
             PreparedStatement preparedStatement2 = this._connection.prepareStatement("select 1 from ResourcePermission where name = ?");
             ResultSet resultSet1 = preparedStatement1.executeQuery();){
            while (resultSet1.next()) {
                String name = resultSet1.getString(1);
                if (!name.startsWith("com.liferay.") && !name.startsWith("com_liferay_") || modelNames.contains(name) || portletNames.contains(name)) continue;
                preparedStatement2.setString(1, name);
                ResultSet resultSet2 = preparedStatement2.executeQuery();
                try {
                    if (resultSet2.next() && _log.isInfoEnabled()) {
                        _log.info((Object)StringBundler.concat((String[])new String[]{"Resource action ", name, " is not defined in any deployed module but ", "is referenced in ", this._dbInspector.normalizeName("ResourcePermission"), " table"}));
                        continue;
                    }
                }
                finally {
                    if (resultSet2 == null) continue;
                    resultSet2.close();
                    continue;
                }
                List resourceActions = this._resourceActionLocalService.getResourceActions(name);
                for (ResourceAction resourceAction : resourceActions) {
                    this._resourceActionLocalService.deleteResourceAction(resourceAction);
                }
                DataCleanupLoggingUtil.logDelete((Log)_log, (long)resourceActions.size(), (String)this._dbInspector.normalizeName("ResourceAction"), (String)StringBundler.concat((String[])new String[]{"'", name, "' is not defined in any deployed module and is not ", "in use"}));
            }
            return;
        }
    }
}

