/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.cleanup.internal;

import com.liferay.change.tracking.service.CTCollectionLocalService;
import com.liferay.change.tracking.service.CTEntryLocalService;
import com.liferay.change.tracking.store.service.CTSContentLocalService;
import com.liferay.data.cleanup.DataCleanup;
import com.liferay.data.cleanup.DataCleanupAdapter;
import com.liferay.data.cleanup.internal.upgrade.AmazonRankingsUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.ChatUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.CurrencyConverterUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.DLPreviewCTSContentDataUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.DictionaryUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.DirectoryUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.DocumentLibraryFileRankServiceUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.ExpiredJournalArticleUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.FrontendImageEditorUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.GoogleMapsUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.HTMLPreviewUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.HelloVelocityUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.InvitationUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.LayoutClassedModelUsageOrphanDataUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.LoanCalculatorUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.MailReaderUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.NetworkUtilitiesUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.OAuthUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.OpenSocialUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.OutdatedPublishedCTCollectionUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.PasswordGeneratorUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.PortalSecurityWedeployAuthUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.PublishedCTSContentDataUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.QuickNoteUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.RecentDocumentsUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.ShoppingUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.SocialActivityUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.SocialGroupStatisticsUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.SocialPrivateMessagingUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.SocialRequestsUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.SocialUserStatisticsUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.SoftwareCatalogUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.SyncUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.TranslatorUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.TwitterUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.UnitConverterUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.UpgradeHelloWorld;
import com.liferay.data.cleanup.internal.upgrade.WeatherUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.WebFormUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.WebProxyUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.WidgetLayoutTypeSettingsUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.WysiwygUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.XSLContentUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.YoutubeUpgradeProcess;
import com.liferay.data.cleanup.internal.verify.ClassNamePostUpgradeDataCleanupProcess;
import com.liferay.data.cleanup.internal.verify.ServiceComponentPostUpgradeDataCleanupProcess;
import com.liferay.data.cleanup.util.DataCleanupUtil;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.layout.manager.ContentManager;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureLocalService;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureRelLocalService;
import com.liferay.layout.service.LayoutClassedModelUsageLocalService;
import com.liferay.message.boards.service.MBMessageLocalService;
import com.liferay.message.boards.service.MBThreadLocalService;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ImageLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ReleaseLocalService;
import com.liferay.portal.kernel.service.ServiceComponentLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.data.cleanup.DataCleanupPreupgradeProcess;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.upgrade.data.cleanup.AnalyticsMessageDataCleanupPreupgradeProcess;
import com.liferay.portal.upgrade.data.cleanup.CompanyDataCleanupPreupgradeProcess;
import com.liferay.portal.upgrade.data.cleanup.ConfigurationDataCleanupPreupgradeProcess;
import com.liferay.portal.upgrade.data.cleanup.CounterDataCleanupPreupgradeProcess;
import com.liferay.portal.upgrade.data.cleanup.DDMDataCleanupPreupgradeProcess;
import com.liferay.portal.upgrade.data.cleanup.DDMStorageLinkDataCleanupPreupgradeProcess;
import com.liferay.portal.upgrade.data.cleanup.DLFileEntryDataCleanupPreupgradeProcess;
import com.liferay.portal.upgrade.data.cleanup.DataCleanupPreupgradeProcessSuite;
import com.liferay.portal.upgrade.data.cleanup.GroupDataCleanupPreupgradeProcess;
import com.liferay.portal.upgrade.data.cleanup.JournalDataCleanupPreupgradeProcess;
import com.liferay.portal.upgrade.data.cleanup.NullUnicodeContentDataCleanupPreupgradeProcess;
import com.liferay.portal.upgrade.data.cleanup.QuartzJobDetailsDataCleanupPreupgradeProcess;
import com.liferay.portal.upgrade.data.cleanup.UserDataCleanupPreupgradeProcess;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.ratings.kernel.service.RatingsStatsLocalService;
import com.liferay.subscription.service.SubscriptionLocalService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={})
public class DataCleanupRegistrator {
    private static final Map<Class<?>, String> _dataCleanupLabels = HashMapBuilder.put(AnalyticsMessageDataCleanupPreupgradeProcess.class, (Object)"remove-analytics-message-data").put(CompanyDataCleanupPreupgradeProcess.class, (Object)"remove-company-orphan-data").put(ConfigurationDataCleanupPreupgradeProcess.class, (Object)"remove-configuration-orphan-data").put(CounterDataCleanupPreupgradeProcess.class, (Object)"fix-counter-values").put(DDMDataCleanupPreupgradeProcess.class, (Object)"remove-ddm-orphan-data").put(DDMStorageLinkDataCleanupPreupgradeProcess.class, (Object)"remove-ddm-orphan-data").put(DLFileEntryDataCleanupPreupgradeProcess.class, (Object)"remove-dl-file-entry-orphan-data").put(GroupDataCleanupPreupgradeProcess.class, (Object)"remove-group-orphan-data").put(JournalDataCleanupPreupgradeProcess.class, (Object)"remove-journal-orphan-data").put(NullUnicodeContentDataCleanupPreupgradeProcess.class, (Object)"remove-null-unicode-content-data").put(QuartzJobDetailsDataCleanupPreupgradeProcess.class, (Object)"remove-quartz-job-details-data").put(UserDataCleanupPreupgradeProcess.class, (Object)"remove-user-orphan-data").build();
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private ContentManager _contentManager;
    @Reference
    private CTCollectionLocalService _ctCollectionLocalService;
    @Reference
    private CTEntryLocalService _ctEntryLocalService;
    @Reference
    private CTSContentLocalService _ctsContentLocalService;
    private final List<DataCleanup> _dataCleanups = new ArrayList<DataCleanup>();
    @Reference
    private ExpandoTableLocalService _expandoTableLocalService;
    @Reference
    private FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    @Reference
    private ImageLocalService _imageLocalService;
    @Reference
    private JournalArticleLocalService _journalArticleLocalService;
    @Reference
    private LayoutClassedModelUsageLocalService _layoutClassedModelUsageLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateStructureLocalService _layoutPageTemplateStructureLocalService;
    @Reference
    private LayoutPageTemplateStructureRelLocalService _layoutPageTemplateStructureRelLocalService;
    @Reference
    private MBMessageLocalService _mbMessageLocalService;
    @Reference
    private MBThreadLocalService _mbThreadLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private RatingsStatsLocalService _ratingsStatsLocalService;
    @Reference
    private ReleaseLocalService _releaseLocalService;
    @Reference
    private ServiceComponentLocalService _serviceComponentLocalService;
    @Reference
    private SubscriptionLocalService _subscriptionLocalService;

    @Activate
    protected void activate() throws Exception {
        this._registerModuleDataCleanups();
        this._registerSystemDataCleanups();
    }

    @Deactivate
    protected void deactivate() throws Exception {
        for (DataCleanup dataCleanup : this._dataCleanups) {
            DataCleanupUtil.unregisterDataCleanup((DataCleanup)dataCleanup);
        }
    }

    private String _getDataCleanupLabel(DataCleanupPreupgradeProcess dataCleanupPreupgradeProcess) {
        return _dataCleanupLabels.get(dataCleanupPreupgradeProcess.getClass());
    }

    private void _registerDataCleanup(DataCleanup dataCleanup) {
        this._dataCleanups.add(dataCleanup);
        DataCleanupUtil.registerDataCleanup((DataCleanup)dataCleanup);
    }

    private void _registerDataCleanup(DataCleanup dataCleanup, String servletContextName) {
        Release release = this._releaseLocalService.fetchRelease(servletContextName);
        if (release != null) {
            this._registerDataCleanup(dataCleanup);
        }
    }

    private void _registerModuleDataCleanups() {
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-amazon-rankings-module-data", (String)"module", (UpgradeProcess)new AmazonRankingsUpgradeProcess()), "com.liferay.amazon.rankings.web");
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-chat-module-data", (String)"module", (UpgradeProcess)new ChatUpgradeProcess()), "com.liferay.chat.service");
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-currency-converter-module-data", (String)"module", (UpgradeProcess)new CurrencyConverterUpgradeProcess()), "com.liferay.currency.converter.web");
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-dictionary-module-data", (String)"module", (UpgradeProcess)new DictionaryUpgradeProcess()), "com.liferay.dictionary.web");
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-directory-module-data", (String)"module", (UpgradeProcess)new DirectoryUpgradeProcess()), "com.liferay.directory.web");
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-document-library-file-rank-module-data", (String)"module", (UpgradeProcess)new DocumentLibraryFileRankServiceUpgradeProcess()), "com.liferay.document.library.file.rank.service");
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-frontend-image-editor-module-data", (String)"module", (UpgradeProcess)new FrontendImageEditorUpgradeProcess()), "com.liferay.frontend.image.editor.web");
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-google-maps-module-data", (String)"module", (UpgradeProcess)new GoogleMapsUpgradeProcess()), "com.liferay.google.maps.web");
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-hello-velocity-module-data", (String)"module", (UpgradeProcess)new HelloVelocityUpgradeProcess()), "com.liferay.hello.velocity.web");
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-hello-world-module-data", (String)"module", (UpgradeProcess)new UpgradeHelloWorld()), "com.liferay.hello.world.web");
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-html-preview-module-data", (String)"module", (UpgradeProcess)new HTMLPreviewUpgradeProcess()), "com.liferay.html.preview.service");
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-invitation-module-data", (String)"module", (UpgradeProcess)new InvitationUpgradeProcess()), "com.liferay.invitation.web");
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-loan-calculator-module-data", (String)"module", (UpgradeProcess)new LoanCalculatorUpgradeProcess()), "com.liferay.loan.calculator.web");
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-mail-reader-module-data", (String)"module", (UpgradeProcess)new MailReaderUpgradeProcess()), "com.liferay.mail.reader.service");
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-network-utilities-module-data", (String)"module", (UpgradeProcess)new NetworkUtilitiesUpgradeProcess()), "com.liferay.network.utilities.web");
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-oauth-module-data", (String)"module", (UpgradeProcess)new OAuthUpgradeProcess()), "com.liferay.oauth.service");
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-password-generator-module-data", (String)"module", (UpgradeProcess)new PasswordGeneratorUpgradeProcess()), "com.liferay.password.generator.web");
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-portal-security-wedeploy-auth-module-data", (String)"module", (UpgradeProcess)new PortalSecurityWedeployAuthUpgradeProcess()), "com.liferay.portal.security.wedeploy.auth.service");
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-quick-note-module-data", (String)"module", (UpgradeProcess)new QuickNoteUpgradeProcess()), "com.liferay.quick.note.web");
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-recent-documents-module-data", (String)"module", (UpgradeProcess)new RecentDocumentsUpgradeProcess()), "com.liferay.recent.documents.web");
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-shopping-module-data", (String)"module", (UpgradeProcess)new ShoppingUpgradeProcess(this._imageLocalService)), "com.liferay.shopping.service");
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-social-activity-module-data", (String)"module", (UpgradeProcess)new SocialActivityUpgradeProcess()), "com.liferay.social.activity.web");
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-social-group-statistics-module-data", (String)"module", (UpgradeProcess)new SocialGroupStatisticsUpgradeProcess()), "com.liferay.social.group.statistics.web");
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-social-private-messaging-module-data", (String)"module", (UpgradeProcess)new SocialPrivateMessagingUpgradeProcess(this._mbThreadLocalService)), "com.liferay.social.privatemessaging.service");
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-social-requests-module-data", (String)"module", (UpgradeProcess)new SocialRequestsUpgradeProcess()), "com.liferay.social.requests.web");
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-social-user-statistics-module-data", (String)"module", (UpgradeProcess)new SocialUserStatisticsUpgradeProcess()), "com.liferay.social.user.statistics.web");
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-software-catalog-module-data", (String)"module", (UpgradeProcess)new SoftwareCatalogUpgradeProcess(this._imageLocalService, this._mbMessageLocalService, this._ratingsStatsLocalService, this._subscriptionLocalService)), "com.liferay.softwarecatalog.service");
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-sync-module-data", (String)"module", (UpgradeProcess)new SyncUpgradeProcess()), "com.liferay.sync.service");
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-translator-module-data", (String)"module", (UpgradeProcess)new TranslatorUpgradeProcess()), "com.liferay.translator.web");
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-twitter-module-data", (String)"module", (UpgradeProcess)new TwitterUpgradeProcess()), "com.liferay.twitter.service");
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-unit-converter-module-data", (String)"module", (UpgradeProcess)new UnitConverterUpgradeProcess()), "com.liferay.unit.converter.web");
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-weather-module-data", (String)"module", (UpgradeProcess)new WeatherUpgradeProcess()), "com.liferay.weather.web");
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-web-form-module-data", (String)"module", (UpgradeProcess)new WebFormUpgradeProcess()), "com.liferay.web.form.web");
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-web-proxy-module-data", (String)"module", (UpgradeProcess)new WebProxyUpgradeProcess()), "com.liferay.web.proxy.web");
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-wysiwyg-module-data", (String)"module", (UpgradeProcess)new WysiwygUpgradeProcess()), "com.liferay.wysiwyg.web");
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-xsl-content-module-data", (String)"module", (UpgradeProcess)new XSLContentUpgradeProcess()), "com.liferay.xsl.content.web");
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-youtube-module-data", (String)"module", (UpgradeProcess)new YoutubeUpgradeProcess()), "com.liferay.youtube.web");
        this._registerDataCleanup(DataCleanupAdapter.create((String)"clean-up-open-social-module-data", (String)"module", (UpgradeProcess)new OpenSocialUpgradeProcess(this._expandoTableLocalService)), "opensocial-portlet");
    }

    private void _registerSystemDataCleanups() {
        this._registerDataCleanup(DataCleanupAdapter.create((String)"remove-class-name-orphan-data", (String)"system", (VerifyProcess)new VerifyProcess(){

            protected void doVerify() throws Exception {
                ClassNamePostUpgradeDataCleanupProcess postUpgradeDataCleanupProcess = new ClassNamePostUpgradeDataCleanupProcess(DataCleanupRegistrator.this._classNameLocalService, this.connection);
                postUpgradeDataCleanupProcess.cleanUp();
            }
        }));
        this._registerDataCleanup(DataCleanupAdapter.create((String)"remove-dl-preview-cts-content-data", (String)"system", (UpgradeProcess)new DLPreviewCTSContentDataUpgradeProcess(this._ctCollectionLocalService, this._ctEntryLocalService, this._portal)), "com.liferay.change.tracking.service");
        this._registerDataCleanup(DataCleanupAdapter.create((String)"remove-expired-journal-articles", (String)"system", (UpgradeProcess)new ExpiredJournalArticleUpgradeProcess(this._journalArticleLocalService)), "com.liferay.journal.service");
        this._registerDataCleanup(DataCleanupAdapter.create((String)"remove-layout-classed-model-usage-orphan-data", (String)"system", (UpgradeProcess)new LayoutClassedModelUsageOrphanDataUpgradeProcess(this._classNameLocalService, this._contentManager, this._ctCollectionLocalService, this._fragmentEntryLinkLocalService, this._layoutClassedModelUsageLocalService, this._layoutPageTemplateStructureLocalService, this._layoutPageTemplateStructureRelLocalService)), "com.liferay.layout.service");
        this._registerDataCleanup(DataCleanupAdapter.create((String)"remove-publications-older-than-6-months", (String)"system", (UpgradeProcess)new OutdatedPublishedCTCollectionUpgradeProcess(this._ctCollectionLocalService)), "com.liferay.change.tracking.service");
        this._registerDataCleanup(DataCleanupAdapter.create((String)"remove-published-cts-content-data", (String)"system", (UpgradeProcess)new PublishedCTSContentDataUpgradeProcess(this._ctsContentLocalService, this._portal)), "com.liferay.change.tracking.store.service");
        this._registerDataCleanup(DataCleanupAdapter.create((String)"remove-service-component-orphan-data", (String)"system", (VerifyProcess)new VerifyProcess(){

            protected void doVerify() throws Exception {
                ServiceComponentPostUpgradeDataCleanupProcess postUpgradeDataCleanupProcess = new ServiceComponentPostUpgradeDataCleanupProcess(this.connection, DataCleanupRegistrator.this._serviceComponentLocalService);
                postUpgradeDataCleanupProcess.cleanUp();
            }
        }));
        this._registerDataCleanup(DataCleanupAdapter.create((String)"remove-widget-layout-type-settings", (String)"system", (UpgradeProcess)new WidgetLayoutTypeSettingsUpgradeProcess(this._layoutLocalService)), "com.liferay.layout.service");
        DataCleanupPreupgradeProcessSuite dataCleanupPreupgradeProcessSuite = new DataCleanupPreupgradeProcessSuite();
        for (DataCleanupPreupgradeProcess dataCleanupPreupgradeProcess : dataCleanupPreupgradeProcessSuite.getSortedDataCleanupPreupgradeProcesses()) {
            String dataCleanupLabel = this._getDataCleanupLabel(dataCleanupPreupgradeProcess);
            if (dataCleanupLabel == null) continue;
            this._registerDataCleanup(DataCleanupAdapter.create((String)dataCleanupLabel, (String)"system", (UpgradeProcess)dataCleanupPreupgradeProcess));
        }
    }
}

