/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.content.dashboard.journal.internal.item.action;

import com.liferay.asset.display.page.portlet.AssetDisplayPageFriendlyURLProvider;
import com.liferay.content.dashboard.item.action.ContentDashboardItemAction;
import com.liferay.journal.model.JournalArticle;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Locale;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;

public class ViewJournalArticleContentDashboardItemAction
implements ContentDashboardItemAction {
    private static final Log _log = LogFactoryUtil.getLog(ViewJournalArticleContentDashboardItemAction.class);
    private final AssetDisplayPageFriendlyURLProvider _assetDisplayPageFriendlyURLProvider;
    private final Http _http;
    private final HttpServletRequest _httpServletRequest;
    private final JournalArticle _journalArticle;
    private final Language _language;

    public ViewJournalArticleContentDashboardItemAction(AssetDisplayPageFriendlyURLProvider assetDisplayPageFriendlyURLProvider, Http http, HttpServletRequest httpServletRequest, JournalArticle journalArticle, Language language) {
        this._assetDisplayPageFriendlyURLProvider = assetDisplayPageFriendlyURLProvider;
        this._http = http;
        this._httpServletRequest = httpServletRequest;
        this._journalArticle = journalArticle;
        this._language = language;
    }

    public String getIcon() {
        return "view";
    }

    public String getLabel(Locale locale) {
        return this._language.get(locale, "view");
    }

    public String getName() {
        return "view";
    }

    public ContentDashboardItemAction.Type getType() {
        return ContentDashboardItemAction.Type.VIEW;
    }

    public String getURL() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return this._getViewURL(themeDisplay.getLocale(), themeDisplay);
    }

    public String getURL(Locale locale) {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return this._getViewURL(locale, themeDisplay);
    }

    private String _getViewURL(Locale locale, ThemeDisplay themeDisplay) {
        try {
            ThemeDisplay clonedThemeDisplay = (ThemeDisplay)themeDisplay.clone();
            clonedThemeDisplay.setScopeGroupId(this._journalArticle.getGroupId());
            return Optional.ofNullable(this._assetDisplayPageFriendlyURLProvider.getFriendlyURL(JournalArticle.class.getName(), this._journalArticle.getResourcePrimKey(), locale, clonedThemeDisplay)).map(url -> {
                String backURL = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"backURL");
                if (Validator.isNotNull((String)backURL)) {
                    return this._http.setParameter(url, "p_l_back_url", backURL);
                }
                return this._http.setParameter(url, "p_l_back_url", themeDisplay.getURLCurrent());
            }).orElse("");
        }
        catch (PortalException | CloneNotSupportedException exception) {
            _log.error((Object)exception, exception);
            return "";
        }
    }
}

