/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.content.dashboard.journal.internal.item;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.content.dashboard.item.ContentDashboardItem;
import com.liferay.content.dashboard.item.ContentDashboardItemFactory;
import com.liferay.content.dashboard.item.action.ContentDashboardItemActionProviderRegistry;
import com.liferay.content.dashboard.item.action.ContentDashboardItemVersionActionProviderRegistry;
import com.liferay.content.dashboard.item.type.ContentDashboardItemSubtypeFactory;
import com.liferay.content.dashboard.item.type.ContentDashboardItemSubtypeFactoryRegistry;
import com.liferay.content.dashboard.journal.internal.item.JournalArticleContentDashboardItem;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.info.item.InfoItemServiceRegistry;
import com.liferay.info.item.provider.InfoItemFieldValuesProvider;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.journal.service.JournalArticleService;
import com.liferay.portal.kernel.exception.NoSuchModelException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.Portal;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ContentDashboardItemFactory.class})
public class JournalArticleContentDashboardItemFactory
implements ContentDashboardItemFactory<JournalArticle> {
    @Reference
    protected InfoItemServiceRegistry infoItemServiceRegistry;
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private ContentDashboardItemActionProviderRegistry _contentDashboardItemActionProviderRegistry;
    @Reference
    private ContentDashboardItemSubtypeFactoryRegistry _contentDashboardItemSubtypeFactoryRegistry;
    @Reference
    private ContentDashboardItemVersionActionProviderRegistry _contentDashboardItemVersionActionProviderRegistry;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private JournalArticleLocalService _journalArticleLocalService;
    @Reference
    private JournalArticleService _journalArticleService;
    @Reference
    private Language _language;
    @Reference
    private Portal _portal;

    public ContentDashboardItem<JournalArticle> create(long classPK) throws PortalException {
        ContentDashboardItemSubtypeFactory contentDashboardItemSubtypeFactory;
        if (classPK == 0L) {
            return null;
        }
        AssetEntry assetEntry = this._assetEntryLocalService.fetchEntry(JournalArticle.class.getName(), classPK);
        if (assetEntry == null) {
            throw new NoSuchModelException("Unable to find an asset entry for journal article class PK " + classPK);
        }
        JournalArticle journalArticle = this._journalArticleLocalService.fetchJournalArticle(classPK);
        if (journalArticle == null) {
            journalArticle = this._journalArticleLocalService.getLatestArticle(classPK, -1, false);
        }
        if ((contentDashboardItemSubtypeFactory = this.getContentDashboardItemSubtypeFactory()) == null) {
            throw new NoSuchModelException();
        }
        DDMStructure ddmStructure = journalArticle.getDDMStructure();
        InfoItemFieldValuesProvider infoItemFieldValuesProvider = (InfoItemFieldValuesProvider)this.infoItemServiceRegistry.getFirstInfoItemService(InfoItemFieldValuesProvider.class, JournalArticle.class.getName());
        JournalArticle latestApprovedJournalArticle = this._journalArticleLocalService.fetchLatestArticle(classPK, 0);
        return new JournalArticleContentDashboardItem(assetEntry.getCategories(), assetEntry.getTags(), this._contentDashboardItemActionProviderRegistry, this._contentDashboardItemVersionActionProviderRegistry, contentDashboardItemSubtypeFactory.create(ddmStructure.getStructureId(), journalArticle.getResourcePrimKey()), this._groupLocalService.fetchGroup(journalArticle.getGroupId()), (InfoItemFieldValuesProvider<JournalArticle>)infoItemFieldValuesProvider, journalArticle, this._journalArticleService, this._language, latestApprovedJournalArticle, this._portal);
    }

    public ContentDashboardItemSubtypeFactory getContentDashboardItemSubtypeFactory() {
        return this._contentDashboardItemSubtypeFactoryRegistry.getContentDashboardItemSubtypeFactory(DDMStructure.class.getName());
    }
}

