/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.content.dashboard.journal.internal.item;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.content.dashboard.item.ContentDashboardItem;
import com.liferay.content.dashboard.item.ContentDashboardItemVersion;
import com.liferay.content.dashboard.item.VersionableContentDashboardItem;
import com.liferay.content.dashboard.item.action.ContentDashboardItemAction;
import com.liferay.content.dashboard.item.action.ContentDashboardItemActionProviderRegistry;
import com.liferay.content.dashboard.item.action.ContentDashboardItemVersionAction;
import com.liferay.content.dashboard.item.action.ContentDashboardItemVersionActionProviderRegistry;
import com.liferay.content.dashboard.item.action.exception.ContentDashboardItemActionException;
import com.liferay.content.dashboard.item.action.exception.ContentDashboardItemVersionActionException;
import com.liferay.content.dashboard.item.action.provider.ContentDashboardItemActionProvider;
import com.liferay.content.dashboard.item.action.provider.ContentDashboardItemVersionActionProvider;
import com.liferay.content.dashboard.item.type.ContentDashboardItemSubtype;
import com.liferay.info.field.InfoFieldValue;
import com.liferay.info.item.InfoItemClassDetails;
import com.liferay.info.item.InfoItemFieldValues;
import com.liferay.info.item.InfoItemReference;
import com.liferay.info.item.provider.InfoItemFieldValuesProvider;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleService;
import com.liferay.journal.util.comparator.ArticleVersionComparator;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.url.builder.PortletURLBuilder;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.workflow.WorkflowConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class JournalArticleContentDashboardItem
implements VersionableContentDashboardItem<JournalArticle> {
    private static final Log _log = LogFactoryUtil.getLog(JournalArticleContentDashboardItem.class);
    private final List<AssetCategory> _assetCategories;
    private final List<AssetTag> _assetTags;
    private final ContentDashboardItemActionProviderRegistry _contentDashboardItemActionProviderRegistry;
    private final ContentDashboardItemSubtype _contentDashboardItemSubtype;
    private final ContentDashboardItemVersionActionProviderRegistry _contentDashboardItemVersionActionProviderRegistry;
    private final Group _group;
    private final InfoItemFieldValuesProvider<JournalArticle> _infoItemFieldValuesProvider;
    private final JournalArticle _journalArticle;
    private final JournalArticleService _journalArticleService;
    private final Language _language;
    private final JournalArticle _latestApprovedJournalArticle;
    private final Portal _portal;

    public JournalArticleContentDashboardItem(List<AssetCategory> assetCategories, List<AssetTag> assetTags, ContentDashboardItemActionProviderRegistry contentDashboardItemActionProviderRegistry, ContentDashboardItemVersionActionProviderRegistry contentDashboardItemVersionActionProviderRegistry, ContentDashboardItemSubtype contentDashboardItemSubtype, Group group, InfoItemFieldValuesProvider<JournalArticle> infoItemFieldValuesProvider, JournalArticle journalArticle, JournalArticleService journalArticleService, Language language, JournalArticle latestApprovedJournalArticle, Portal portal) {
        this._assetCategories = ListUtil.isEmpty(assetCategories) ? Collections.emptyList() : Collections.unmodifiableList(assetCategories);
        this._assetTags = ListUtil.isEmpty(assetTags) ? Collections.emptyList() : Collections.unmodifiableList(assetTags);
        this._contentDashboardItemActionProviderRegistry = contentDashboardItemActionProviderRegistry;
        this._contentDashboardItemVersionActionProviderRegistry = contentDashboardItemVersionActionProviderRegistry;
        this._contentDashboardItemSubtype = contentDashboardItemSubtype;
        this._group = group;
        this._infoItemFieldValuesProvider = infoItemFieldValuesProvider;
        this._journalArticle = journalArticle;
        this._journalArticleService = journalArticleService;
        this._language = language;
        this._latestApprovedJournalArticle = !journalArticle.equals(latestApprovedJournalArticle) ? latestApprovedJournalArticle : null;
        this._portal = portal;
    }

    public List<ContentDashboardItemVersion> getAllContentDashboardItemVersions(HttpServletRequest httpServletRequest) {
        int status = 0;
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        User user = themeDisplay.getUser();
        if (user.getUserId() == this._journalArticle.getUserId() || permissionChecker.isContentReviewer(user.getCompanyId(), themeDisplay.getScopeGroupId())) {
            status = -1;
        }
        List journalArticles = this._journalArticleService.getArticlesByArticleId(this._journalArticle.getGroupId(), this._journalArticle.getArticleId(), status, -1, -1, (OrderByComparator)new ArticleVersionComparator());
        return ListUtil.toList((List)journalArticles, journalArticle -> new ContentDashboardItemVersion(null, this._getContentDashboardItemVersionActions(httpServletRequest, (JournalArticle)journalArticle), journalArticle.getStatusDate(), this._language.get(themeDisplay.getLocale(), WorkflowConstants.getStatusLabel((int)journalArticle.getStatus())), themeDisplay.getLocale(), WorkflowConstants.getStatusStyle((int)journalArticle.getStatus()), journalArticle.getStatusByUserName(), String.valueOf(journalArticle.getVersion())));
    }

    public List<AssetCategory> getAssetCategories() {
        return this._assetCategories;
    }

    public List<AssetCategory> getAssetCategories(long assetVocabularyId) {
        return ListUtil.filter(this._assetCategories, assetCategory -> assetCategory.getVocabularyId() == assetVocabularyId);
    }

    public List<AssetTag> getAssetTags() {
        return this._assetTags;
    }

    public List<Locale> getAvailableLocales() {
        return TransformUtil.transformToList((Object[])this._journalArticle.getAvailableLanguageIds(), LocaleUtil::fromLanguageId);
    }

    public List<ContentDashboardItemAction> getContentDashboardItemActions(HttpServletRequest httpServletRequest, ContentDashboardItemAction.Type ... types) {
        return TransformUtil.transform((Collection)this._contentDashboardItemActionProviderRegistry.getContentDashboardItemActionProviders(JournalArticle.class.getName(), types), contentDashboardItemActionProvider -> {
            try {
                return contentDashboardItemActionProvider.getContentDashboardItemAction((Object)this._journalArticle, httpServletRequest);
            }
            catch (ContentDashboardItemActionException contentDashboardItemActionException) {
                _log.error((Throwable)contentDashboardItemActionException);
                return null;
            }
        });
    }

    public ContentDashboardItemSubtype getContentDashboardItemSubtype() {
        return this._contentDashboardItemSubtype;
    }

    public Date getCreateDate() {
        return this._journalArticle.getCreateDate();
    }

    public ContentDashboardItemAction getDefaultContentDashboardItemAction(HttpServletRequest httpServletRequest) {
        long userId = this._portal.getUserId(httpServletRequest);
        Locale locale = this._portal.getLocale(httpServletRequest);
        ContentDashboardItemVersion contentDashboardItemVersion = this._getLastContentDashboardItemVersion(locale);
        if (this.getUserId() == userId && Objects.equals(contentDashboardItemVersion.getLabel(), this._language.get(locale, WorkflowConstants.getStatusLabel((int)2)))) {
            ContentDashboardItemActionProvider contentDashboardItemActionProvider = this._contentDashboardItemActionProviderRegistry.getContentDashboardItemActionProvider(JournalArticle.class.getName(), ContentDashboardItemAction.Type.EDIT);
            if (contentDashboardItemActionProvider == null) {
                return null;
            }
            ContentDashboardItemAction contentDashboardItemAction = this._toContentDashboardItemAction(contentDashboardItemActionProvider, httpServletRequest);
            if (contentDashboardItemAction == null) {
                return null;
            }
            return contentDashboardItemAction;
        }
        ContentDashboardItemActionProvider viewContentDashboardItemActionProvider = this._contentDashboardItemActionProviderRegistry.getContentDashboardItemActionProvider(JournalArticle.class.getName(), ContentDashboardItemAction.Type.VIEW);
        if (viewContentDashboardItemActionProvider == null) {
            return this._getContentDashboardItemAction(httpServletRequest);
        }
        ContentDashboardItemAction contentDashboardItemAction = this._toContentDashboardItemAction(viewContentDashboardItemActionProvider, httpServletRequest);
        if (contentDashboardItemAction == null) {
            return this._getContentDashboardItemAction(httpServletRequest);
        }
        return contentDashboardItemAction;
    }

    public Locale getDefaultLocale() {
        return LocaleUtil.fromLanguageId((String)this._journalArticle.getDefaultLanguageId());
    }

    public String getDescription(Locale locale) {
        return this._getStringValue("description", locale);
    }

    public long getId() {
        return this._journalArticle.getResourcePrimKey();
    }

    public InfoItemReference getInfoItemReference() {
        return new InfoItemReference(JournalArticle.class.getName(), this._journalArticle.getResourcePrimKey());
    }

    public List<ContentDashboardItemVersion> getLatestContentDashboardItemVersions(Locale locale) {
        ArrayList<ContentDashboardItemVersion> contentDashboardItemVersions = new ArrayList<ContentDashboardItemVersion>();
        ContentDashboardItemVersion contentDashboardItemVersion = this._toVersion(this._journalArticle, locale);
        if (contentDashboardItemVersion != null) {
            contentDashboardItemVersions.add(contentDashboardItemVersion);
        }
        if ((contentDashboardItemVersion = this._toVersion(this._latestApprovedJournalArticle, locale)) != null) {
            contentDashboardItemVersions.add(contentDashboardItemVersion);
        }
        contentDashboardItemVersions.sort(Comparator.comparing(ContentDashboardItemVersion::getVersion));
        return contentDashboardItemVersions;
    }

    public Date getModifiedDate() {
        return this._journalArticle.getModifiedDate();
    }

    public Date getReviewDate() {
        return this._journalArticle.getReviewDate();
    }

    public String getScopeName(Locale locale) {
        if (this._group == null) {
            return "";
        }
        String scopeName = null;
        try {
            scopeName = this._group.getDescriptiveName(locale);
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
        }
        if (scopeName == null) {
            return this._group.getName(locale);
        }
        return scopeName;
    }

    public List<ContentDashboardItem.SpecificInformation<?>> getSpecificInformationList(Locale locale) {
        return Arrays.asList(new ContentDashboardItem.SpecificInformation("display-date", ContentDashboardItem.SpecificInformation.Type.DATE, (Object)this._journalArticle.getDisplayDate()), new ContentDashboardItem.SpecificInformation("expiration-date", ContentDashboardItem.SpecificInformation.Type.DATE, (Object)this._journalArticle.getExpirationDate()), new ContentDashboardItem.SpecificInformation("review-date", ContentDashboardItem.SpecificInformation.Type.DATE, (Object)this._journalArticle.getReviewDate()));
    }

    public String getTitle(Locale locale) {
        return this._journalArticle.getTitle(locale);
    }

    public String getTypeLabel(Locale locale) {
        InfoItemClassDetails infoItemClassDetails = new InfoItemClassDetails(JournalArticle.class.getName());
        return infoItemClassDetails.getLabel(locale);
    }

    public long getUserId() {
        if (this._latestApprovedJournalArticle != null) {
            return this._latestApprovedJournalArticle.getStatusByUserId();
        }
        return this._journalArticle.getStatusByUserId();
    }

    public String getUserName() {
        if (this._latestApprovedJournalArticle != null) {
            return this._latestApprovedJournalArticle.getStatusByUserName();
        }
        return this._journalArticle.getStatusByUserName();
    }

    public String getViewVersionsURL(HttpServletRequest httpServletRequest) {
        return PortletURLBuilder.create((PortletURL)this._portal.getControlPanelPortletURL(httpServletRequest, GroupLocalServiceUtil.fetchGroup((long)this._journalArticle.getGroupId()), "com_liferay_journal_web_portlet_JournalPortlet", 0L, 0L, "RENDER_PHASE")).setMVCPath("/view_article_history.jsp").setBackURL(() -> {
            LiferayPortletResponse liferayPortletResponse = this._portal.getLiferayPortletResponse((PortletResponse)httpServletRequest.getAttribute("javax.portlet.response"));
            return liferayPortletResponse.createRenderURL();
        }).setParameter("articleId", this._journalArticle.getArticleId()).buildString();
    }

    public boolean isViewable(HttpServletRequest httpServletRequest) {
        if (!this._journalArticle.hasApprovedVersion()) {
            return false;
        }
        ContentDashboardItemActionProvider contentDashboardItemActionProvider = this._contentDashboardItemActionProviderRegistry.getContentDashboardItemActionProvider(JournalArticle.class.getName(), ContentDashboardItemAction.Type.VIEW);
        if (contentDashboardItemActionProvider == null) {
            return false;
        }
        return contentDashboardItemActionProvider.isShow((Object)this._journalArticle, httpServletRequest);
    }

    private ContentDashboardItemAction _getContentDashboardItemAction(HttpServletRequest httpServletRequest) {
        ContentDashboardItemActionProvider editContentDashboardItemActionProvider = this._contentDashboardItemActionProviderRegistry.getContentDashboardItemActionProvider(JournalArticle.class.getName(), ContentDashboardItemAction.Type.EDIT);
        if (editContentDashboardItemActionProvider == null) {
            return null;
        }
        ContentDashboardItemAction contentDashboardItemAction = this._toContentDashboardItemAction(editContentDashboardItemActionProvider, httpServletRequest);
        if (contentDashboardItemAction == null) {
            return null;
        }
        return contentDashboardItemAction;
    }

    private List<ContentDashboardItemVersionAction> _getContentDashboardItemVersionActions(HttpServletRequest httpServletRequest, JournalArticle journalArticleVersion) {
        ArrayList<ContentDashboardItemVersionAction> contentDashboardItemVersionActions = new ArrayList<ContentDashboardItemVersionAction>();
        List contentDashboardItemVersionActionProviders = this._contentDashboardItemVersionActionProviderRegistry.getContentDashboardItemVersionActionProviders(JournalArticle.class.getName());
        for (ContentDashboardItemVersionActionProvider contentDashboardItemVersionActionProvider : contentDashboardItemVersionActionProviders) {
            if (!contentDashboardItemVersionActionProvider.isShow((Object)journalArticleVersion, httpServletRequest)) continue;
            try {
                ContentDashboardItemVersionAction contentDashboardItemVersionAction = contentDashboardItemVersionActionProvider.getContentDashboardItemVersionAction((Object)journalArticleVersion, httpServletRequest);
                if (contentDashboardItemVersionAction == null) continue;
                contentDashboardItemVersionActions.add(contentDashboardItemVersionAction);
            }
            catch (ContentDashboardItemVersionActionException contentDashboardItemVersionActionException) {
                _log.error((Throwable)contentDashboardItemVersionActionException);
            }
        }
        return contentDashboardItemVersionActions;
    }

    private ContentDashboardItemVersion _getLastContentDashboardItemVersion(Locale locale) {
        List<ContentDashboardItemVersion> contentDashboardItemVersions = this.getLatestContentDashboardItemVersions(locale);
        return contentDashboardItemVersions.get(contentDashboardItemVersions.size() - 1);
    }

    private String _getStringValue(String infoFieldName, Locale locale) {
        InfoItemFieldValues infoItemFieldValues = this._infoItemFieldValuesProvider.getInfoItemFieldValues((Object)this._journalArticle);
        InfoFieldValue infoFieldValue = infoItemFieldValues.getInfoFieldValue(infoFieldName);
        if (infoFieldValue == null) {
            return "";
        }
        Object value = infoFieldValue.getValue(locale);
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    private ContentDashboardItemAction _toContentDashboardItemAction(ContentDashboardItemActionProvider contentDashboardItemActionProvider, HttpServletRequest httpServletRequest) {
        try {
            return contentDashboardItemActionProvider.getContentDashboardItemAction((Object)this._journalArticle, httpServletRequest);
        }
        catch (ContentDashboardItemActionException contentDashboardItemActionException) {
            _log.error((Throwable)contentDashboardItemActionException);
            return null;
        }
    }

    private ContentDashboardItemVersion _toVersion(JournalArticle journalArticle, Locale locale) {
        if (journalArticle == null) {
            return null;
        }
        return new ContentDashboardItemVersion(null, null, journalArticle.getCreateDate(), this._language.get(locale, WorkflowConstants.getStatusLabel((int)journalArticle.getStatus())), null, WorkflowConstants.getStatusStyle((int)journalArticle.getStatus()), journalArticle.getStatusByUserName(), String.valueOf(journalArticle.getVersion()));
    }
}

