/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.content.dashboard.journal.internal.item.action;

import com.liferay.asset.display.page.portlet.AssetDisplayPageFriendlyURLProvider;
import com.liferay.asset.display.page.util.AssetDisplayPageUtil;
import com.liferay.content.dashboard.item.action.ContentDashboardItemAction;
import com.liferay.info.item.InfoItemReference;
import com.liferay.journal.model.JournalArticle;
import com.liferay.layout.display.page.LayoutDisplayPageObjectProvider;
import com.liferay.layout.display.page.LayoutDisplayPageProvider;
import com.liferay.layout.display.page.LayoutDisplayPageProviderRegistry;
import com.liferay.layout.seo.kernel.LayoutSEOLink;
import com.liferay.layout.seo.kernel.LayoutSEOLinkManager;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;

public class ViewJournalArticleContentDashboardItemAction
implements ContentDashboardItemAction {
    private static final Log _log = LogFactoryUtil.getLog(ViewJournalArticleContentDashboardItemAction.class);
    private final HttpServletRequest _httpServletRequest;
    private final JournalArticle _journalArticle;
    private final Language _language;
    private final LayoutDisplayPageProviderRegistry _layoutDisplayPageProviderRegistry;
    private final LayoutLocalService _layoutLocalService;
    private final LayoutSEOLinkManager _layoutSEOLinkManager;
    private final Portal _portal;

    public ViewJournalArticleContentDashboardItemAction(AssetDisplayPageFriendlyURLProvider assetDisplayPageFriendlyURLProvider, HttpServletRequest httpServletRequest, JournalArticle journalArticle, Language language, LayoutDisplayPageProviderRegistry layoutDisplayPageProviderRegistry, LayoutLocalService layoutLocalService, LayoutSEOLinkManager layoutSEOLinkManager, Portal portal) {
        this._httpServletRequest = httpServletRequest;
        this._journalArticle = journalArticle;
        this._language = language;
        this._layoutDisplayPageProviderRegistry = layoutDisplayPageProviderRegistry;
        this._layoutLocalService = layoutLocalService;
        this._layoutSEOLinkManager = layoutSEOLinkManager;
        this._portal = portal;
    }

    public String getIcon() {
        return "view";
    }

    public String getLabel(Locale locale) {
        return this._language.get(locale, "view");
    }

    public String getName() {
        return "view";
    }

    public ContentDashboardItemAction.Type getType() {
        return ContentDashboardItemAction.Type.VIEW;
    }

    public String getURL() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return this._getViewURL(themeDisplay.getLocale(), themeDisplay);
    }

    public String getURL(Locale locale) {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return this._getViewURL(locale, themeDisplay);
    }

    private LayoutDisplayPageObjectProvider<JournalArticle> _getLayoutDisplayPageObjectProvider(JournalArticle journalArticle) {
        LayoutDisplayPageProvider layoutDisplayPageProvider = this._layoutDisplayPageProviderRegistry.getLayoutDisplayPageProviderByClassName(JournalArticle.class.getName());
        if (layoutDisplayPageProvider == null) {
            return null;
        }
        return layoutDisplayPageProvider.getLayoutDisplayPageObjectProvider(new InfoItemReference(JournalArticle.class.getName(), journalArticle.getResourcePrimKey()));
    }

    private Optional<Layout> _getLayoutOptional(LayoutDisplayPageObjectProvider<?> layoutDisplayPageObjectProvider) {
        return Optional.ofNullable(layoutDisplayPageObjectProvider).filter(currentLayoutDisplayPageObjectProvider -> currentLayoutDisplayPageObjectProvider.getDisplayObject() != null).map(currentLayoutDisplayPageObjectProvider -> AssetDisplayPageUtil.getAssetDisplayPageLayoutPageTemplateEntry((long)layoutDisplayPageObjectProvider.getGroupId(), (long)layoutDisplayPageObjectProvider.getClassNameId(), (long)layoutDisplayPageObjectProvider.getClassPK(), (long)layoutDisplayPageObjectProvider.getClassTypeId())).map(layoutPageTemplateEntry -> this._layoutLocalService.fetchLayout(layoutPageTemplateEntry.getPlid()));
    }

    private String _getLocalizedURL(Locale locale, List<LayoutSEOLink> localizedLayoutSEOLinks) {
        ArrayList layoutSEOLinks = new ArrayList();
        ListUtil.filter(localizedLayoutSEOLinks, layoutSEOLinks, seoLink -> Objects.equals(LocaleUtil.toW3cLanguageId((Locale)locale), seoLink.getHrefLang()));
        LayoutSEOLink localizedLayoutSEOLink = (LayoutSEOLink)layoutSEOLinks.get(0);
        return localizedLayoutSEOLink.getHref();
    }

    private String _getViewURL(Locale locale, ThemeDisplay themeDisplay) {
        if (themeDisplay == null) {
            return "";
        }
        Optional<Layout> layoutOptional = this._getLayoutOptional(this._getLayoutDisplayPageObjectProvider(this._journalArticle));
        return layoutOptional.map(layout -> {
            HttpServletRequest httpServletRequest = themeDisplay.getRequest();
            LayoutDisplayPageObjectProvider initialLayoutDisplayPageObjectProvider = (LayoutDisplayPageObjectProvider)httpServletRequest.getAttribute("LAYOUT_DISPLAY_PAGE_OBJECT_PROVIDER");
            httpServletRequest.setAttribute("LAYOUT_DISPLAY_PAGE_OBJECT_PROVIDER", this._getLayoutDisplayPageObjectProvider(this._journalArticle));
            String completeURL = this._portal.getCurrentCompleteURL(httpServletRequest);
            try {
                List localizedLayoutSEOLinks = this._layoutSEOLinkManager.getLocalizedLayoutSEOLinks(layout, this._portal.getSiteDefaultLocale(this._portal.getScopeGroupId(this._httpServletRequest)), this._portal.getCanonicalURL(completeURL, themeDisplay, layout, false, false), Collections.singleton(locale));
                String string = this._getLocalizedURL(locale, localizedLayoutSEOLinks);
                return string;
            }
            catch (PortalException portalException) {
                _log.error((Throwable)portalException);
                String string = "";
                return string;
            }
            finally {
                httpServletRequest.setAttribute("LAYOUT_DISPLAY_PAGE_OBJECT_PROVIDER", (Object)initialLayoutDisplayPageObjectProvider);
            }
        }).map(url -> {
            String backURL = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"backURL");
            if (Validator.isNotNull((String)backURL)) {
                return HttpComponentsUtil.setParameter((String)url, (String)"p_l_back_url", (String)backURL);
            }
            return HttpComponentsUtil.setParameter((String)url, (String)"p_l_back_url", (String)themeDisplay.getURLCurrent());
        }).orElse("");
    }
}

