/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.content.dashboard.journal.internal.item;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.content.dashboard.item.ContentDashboardItemVersion;
import com.liferay.content.dashboard.item.VersionableContentDashboardItem;
import com.liferay.content.dashboard.item.action.ContentDashboardItemAction;
import com.liferay.content.dashboard.item.action.ContentDashboardItemActionProviderTracker;
import com.liferay.content.dashboard.item.action.ContentDashboardItemVersionAction;
import com.liferay.content.dashboard.item.action.ContentDashboardItemVersionActionProviderTracker;
import com.liferay.content.dashboard.item.action.exception.ContentDashboardItemActionException;
import com.liferay.content.dashboard.item.action.exception.ContentDashboardItemVersionActionException;
import com.liferay.content.dashboard.item.action.provider.ContentDashboardItemActionProvider;
import com.liferay.content.dashboard.item.action.provider.ContentDashboardItemVersionActionProvider;
import com.liferay.content.dashboard.item.type.ContentDashboardItemSubtype;
import com.liferay.info.item.InfoItemClassDetails;
import com.liferay.info.item.InfoItemFieldValues;
import com.liferay.info.item.InfoItemReference;
import com.liferay.info.item.provider.InfoItemFieldValuesProvider;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleService;
import com.liferay.journal.util.comparator.ArticleVersionComparator;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.url.builder.PortletURLBuilder;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.workflow.WorkflowConstants;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class JournalArticleContentDashboardItem
implements VersionableContentDashboardItem<JournalArticle> {
    private static final Log _log = LogFactoryUtil.getLog(JournalArticleContentDashboardItem.class);
    private final List<AssetCategory> _assetCategories;
    private final List<AssetTag> _assetTags;
    private final ContentDashboardItemActionProviderTracker _contentDashboardItemActionProviderTracker;
    private final ContentDashboardItemSubtype _contentDashboardItemSubtype;
    private final ContentDashboardItemVersionActionProviderTracker _contentDashboardItemVersionActionProviderTracker;
    private final Group _group;
    private final InfoItemFieldValuesProvider<JournalArticle> _infoItemFieldValuesProvider;
    private final JournalArticle _journalArticle;
    private final JournalArticleService _journalArticleService;
    private final Language _language;
    private final JournalArticle _latestApprovedJournalArticle;
    private final Portal _portal;

    public JournalArticleContentDashboardItem(List<AssetCategory> assetCategories, List<AssetTag> assetTags, ContentDashboardItemActionProviderTracker contentDashboardItemActionProviderTracker, ContentDashboardItemVersionActionProviderTracker contentDashboardItemVersionActionProviderTracker, ContentDashboardItemSubtype contentDashboardItemSubtype, Group group, InfoItemFieldValuesProvider<JournalArticle> infoItemFieldValuesProvider, JournalArticle journalArticle, JournalArticleService journalArticleService, Language language, JournalArticle latestApprovedJournalArticle, Portal portal) {
        this._assetCategories = ListUtil.isEmpty(assetCategories) ? Collections.emptyList() : Collections.unmodifiableList(assetCategories);
        this._assetTags = ListUtil.isEmpty(assetTags) ? Collections.emptyList() : Collections.unmodifiableList(assetTags);
        this._contentDashboardItemActionProviderTracker = contentDashboardItemActionProviderTracker;
        this._contentDashboardItemVersionActionProviderTracker = contentDashboardItemVersionActionProviderTracker;
        this._contentDashboardItemSubtype = contentDashboardItemSubtype;
        this._group = group;
        this._infoItemFieldValuesProvider = infoItemFieldValuesProvider;
        this._journalArticle = journalArticle;
        this._journalArticleService = journalArticleService;
        this._language = language;
        this._latestApprovedJournalArticle = !journalArticle.equals(latestApprovedJournalArticle) ? latestApprovedJournalArticle : null;
        this._portal = portal;
    }

    public List<ContentDashboardItemVersion> getAllContentDashboardItemVersions(HttpServletRequest httpServletRequest) {
        int status = 0;
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        User user = themeDisplay.getUser();
        if (user.getUserId() == this._journalArticle.getUserId() || permissionChecker.isContentReviewer(user.getCompanyId(), themeDisplay.getScopeGroupId())) {
            status = -1;
        }
        List journalArticles = this._journalArticleService.getArticlesByArticleId(this._journalArticle.getGroupId(), this._journalArticle.getArticleId(), status, -1, -1, (OrderByComparator)new ArticleVersionComparator());
        return ListUtil.toList((List)journalArticles, journalArticle -> new ContentDashboardItemVersion(null, this._getContentDashboardItemVersionActions(httpServletRequest, (JournalArticle)journalArticle), journalArticle.getStatusDate(), this._language.get(themeDisplay.getLocale(), WorkflowConstants.getStatusLabel((int)journalArticle.getStatus())), themeDisplay.getLocale(), WorkflowConstants.getStatusStyle((int)journalArticle.getStatus()), journalArticle.getUserName(), String.valueOf(journalArticle.getVersion())));
    }

    public List<AssetCategory> getAssetCategories() {
        return this._assetCategories;
    }

    public List<AssetCategory> getAssetCategories(long assetVocabularyId) {
        Stream stream = this._assetCategories.stream();
        return stream.filter(assetCategory -> assetCategory.getVocabularyId() == assetVocabularyId).collect(Collectors.toList());
    }

    public List<AssetTag> getAssetTags() {
        return this._assetTags;
    }

    public List<Locale> getAvailableLocales() {
        return Stream.of(this._journalArticle.getAvailableLanguageIds()).map(LocaleUtil::fromLanguageId).collect(Collectors.toList());
    }

    public List<ContentDashboardItemAction> getContentDashboardItemActions(HttpServletRequest httpServletRequest, ContentDashboardItemAction.Type ... types) {
        List contentDashboardItemActionProviders = this._contentDashboardItemActionProviderTracker.getContentDashboardItemActionProviders(JournalArticle.class.getName(), types);
        Stream stream = contentDashboardItemActionProviders.stream();
        return stream.map(contentDashboardItemActionProvider -> {
            try {
                return Optional.ofNullable(contentDashboardItemActionProvider.getContentDashboardItemAction((Object)this._journalArticle, httpServletRequest));
            }
            catch (ContentDashboardItemActionException contentDashboardItemActionException) {
                _log.error((Throwable)contentDashboardItemActionException);
                return Optional.empty();
            }
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public ContentDashboardItemSubtype getContentDashboardItemSubtype() {
        return this._contentDashboardItemSubtype;
    }

    public Date getCreateDate() {
        return this._journalArticle.getCreateDate();
    }

    public ContentDashboardItemAction getDefaultContentDashboardItemAction(HttpServletRequest httpServletRequest) {
        long userId = this._portal.getUserId(httpServletRequest);
        Locale locale = this._portal.getLocale(httpServletRequest);
        ContentDashboardItemVersion contentDashboardItemVersion = this._getLastContentDashboardItemVersion(locale);
        if (this.getUserId() == userId && Objects.equals(contentDashboardItemVersion.getLabel(), this._language.get(locale, WorkflowConstants.getStatusLabel((int)2)))) {
            Optional contentDashboardItemActionProviderOptional = this._contentDashboardItemActionProviderTracker.getContentDashboardItemActionProviderOptional(JournalArticle.class.getName(), ContentDashboardItemAction.Type.EDIT);
            return contentDashboardItemActionProviderOptional.map(contentDashboardItemActionProvider -> this._toContentDashboardItemAction((ContentDashboardItemActionProvider)contentDashboardItemActionProvider, httpServletRequest)).orElse(null);
        }
        Optional viewContentDashboardItemActionProviderOptional = this._contentDashboardItemActionProviderTracker.getContentDashboardItemActionProviderOptional(JournalArticle.class.getName(), ContentDashboardItemAction.Type.VIEW);
        return viewContentDashboardItemActionProviderOptional.map(contentDashboardItemActionProvider -> this._toContentDashboardItemAction((ContentDashboardItemActionProvider)contentDashboardItemActionProvider, httpServletRequest)).orElseGet(() -> {
            Optional editContentDashboardItemActionProviderOptional = this._contentDashboardItemActionProviderTracker.getContentDashboardItemActionProviderOptional(JournalArticle.class.getName(), ContentDashboardItemAction.Type.EDIT);
            return editContentDashboardItemActionProviderOptional.map(contentDashboardItemActionProvider -> this._toContentDashboardItemAction((ContentDashboardItemActionProvider)contentDashboardItemActionProvider, httpServletRequest)).orElse(null);
        });
    }

    public Locale getDefaultLocale() {
        return LocaleUtil.fromLanguageId((String)this._journalArticle.getDefaultLanguageId());
    }

    public String getDescription(Locale locale) {
        return this._getStringValue("description", locale);
    }

    public InfoItemReference getInfoItemReference() {
        return new InfoItemReference(JournalArticle.class.getName(), this._journalArticle.getResourcePrimKey());
    }

    public List<ContentDashboardItemVersion> getLatestContentDashboardItemVersions(Locale locale) {
        return Stream.of(this._toVersionOptional(this._journalArticle, locale), this._toVersionOptional(this._latestApprovedJournalArticle, locale)).filter(Optional::isPresent).map(Optional::get).sorted(Comparator.comparing(ContentDashboardItemVersion::getVersion)).collect(Collectors.toList());
    }

    public Date getModifiedDate() {
        return this._journalArticle.getModifiedDate();
    }

    public String getScopeName(Locale locale) {
        return Optional.ofNullable(this._group).map(group -> {
            try {
                return Optional.ofNullable(group.getDescriptiveName(locale)).orElseGet(() -> group.getName(locale));
            }
            catch (PortalException portalException) {
                _log.error((Throwable)portalException);
                return group.getName(locale);
            }
        }).orElse("");
    }

    public Map<String, Object> getSpecificInformation(Locale locale) {
        return HashMapBuilder.put((Object)"display-date", (Object)this._journalArticle.getDisplayDate()).put((Object)"expiration-date", (Object)this._journalArticle.getExpirationDate()).put((Object)"review-date", (Object)this._journalArticle.getReviewDate()).build();
    }

    public String getTitle(Locale locale) {
        return this._journalArticle.getTitle(locale);
    }

    public String getTypeLabel(Locale locale) {
        InfoItemClassDetails infoItemClassDetails = new InfoItemClassDetails(JournalArticle.class.getName());
        return infoItemClassDetails.getLabel(locale);
    }

    public long getUserId() {
        if (this._latestApprovedJournalArticle != null) {
            return this._latestApprovedJournalArticle.getUserId();
        }
        return this._journalArticle.getUserId();
    }

    public String getUserName() {
        if (this._latestApprovedJournalArticle != null) {
            return this._latestApprovedJournalArticle.getUserName();
        }
        return this._journalArticle.getUserName();
    }

    public String getViewVersionsURL(HttpServletRequest httpServletRequest) {
        return PortletURLBuilder.create((PortletURL)this._portal.getControlPanelPortletURL(httpServletRequest, GroupLocalServiceUtil.fetchGroup((long)this._journalArticle.getGroupId()), "com_liferay_journal_web_portlet_JournalPortlet", 0L, 0L, "RENDER_PHASE")).setMVCPath("/view_article_history.jsp").setBackURL(() -> {
            LiferayPortletResponse liferayPortletResponse = this._portal.getLiferayPortletResponse((PortletResponse)httpServletRequest.getAttribute("javax.portlet.response"));
            return liferayPortletResponse.createRenderURL();
        }).setParameter("articleId", this._journalArticle.getArticleId()).buildString();
    }

    public boolean isViewable(HttpServletRequest httpServletRequest) {
        if (!this._journalArticle.hasApprovedVersion()) {
            return false;
        }
        Optional contentDashboardItemActionProviderOptional = this._contentDashboardItemActionProviderTracker.getContentDashboardItemActionProviderOptional(JournalArticle.class.getName(), ContentDashboardItemAction.Type.VIEW);
        return contentDashboardItemActionProviderOptional.map(contentDashboardItemActionProvider -> contentDashboardItemActionProvider.isShow((Object)this._journalArticle, httpServletRequest)).orElse(false);
    }

    private List<ContentDashboardItemVersionAction> _getContentDashboardItemVersionActions(HttpServletRequest httpServletRequest, JournalArticle journalArticleVersion) {
        ArrayList<ContentDashboardItemVersionAction> contentDashboardItemVersionActions = new ArrayList<ContentDashboardItemVersionAction>();
        List contentDashboardItemVersionActionProviders = this._contentDashboardItemVersionActionProviderTracker.getContentDashboardItemVersionActionProviders(JournalArticle.class.getName());
        for (ContentDashboardItemVersionActionProvider contentDashboardItemVersionActionProvider : contentDashboardItemVersionActionProviders) {
            if (!contentDashboardItemVersionActionProvider.isShow((Object)journalArticleVersion, httpServletRequest)) continue;
            try {
                ContentDashboardItemVersionAction contentDashboardItemVersionAction = contentDashboardItemVersionActionProvider.getContentDashboardItemVersionAction((Object)journalArticleVersion, httpServletRequest);
                if (contentDashboardItemVersionAction == null) continue;
                contentDashboardItemVersionActions.add(contentDashboardItemVersionAction);
            }
            catch (ContentDashboardItemVersionActionException contentDashboardItemVersionActionException) {
                _log.error((Throwable)contentDashboardItemVersionActionException);
            }
        }
        return contentDashboardItemVersionActions;
    }

    private ContentDashboardItemVersion _getLastContentDashboardItemVersion(Locale locale) {
        List<ContentDashboardItemVersion> contentDashboardItemVersions = this.getLatestContentDashboardItemVersions(locale);
        return contentDashboardItemVersions.get(contentDashboardItemVersions.size() - 1);
    }

    private String _getStringValue(String infoFieldName, Locale locale) {
        InfoItemFieldValues infoItemFieldValues = this._infoItemFieldValuesProvider.getInfoItemFieldValues((Object)this._journalArticle);
        return Optional.ofNullable(infoItemFieldValues.getInfoFieldValue(infoFieldName)).map(infoFieldValue -> infoFieldValue.getValue(locale)).orElse("").toString();
    }

    private ContentDashboardItemAction _toContentDashboardItemAction(ContentDashboardItemActionProvider contentDashboardItemActionProvider, HttpServletRequest httpServletRequest) {
        try {
            return contentDashboardItemActionProvider.getContentDashboardItemAction((Object)this._journalArticle, httpServletRequest);
        }
        catch (ContentDashboardItemActionException contentDashboardItemActionException) {
            _log.error((Throwable)contentDashboardItemActionException);
            return null;
        }
    }

    private Optional<ContentDashboardItemVersion> _toVersionOptional(JournalArticle journalArticle, Locale locale) {
        return Optional.ofNullable(journalArticle).map(curJournalArticle -> new ContentDashboardItemVersion(null, null, curJournalArticle.getCreateDate(), this._language.get(locale, WorkflowConstants.getStatusLabel((int)curJournalArticle.getStatus())), null, WorkflowConstants.getStatusStyle((int)curJournalArticle.getStatus()), curJournalArticle.getUserName(), String.valueOf(curJournalArticle.getVersion())));
    }
}

