/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.content.dashboard.journal.internal.item.type;

import com.liferay.content.dashboard.item.type.ContentDashboardItemSubtype;
import com.liferay.content.dashboard.item.type.ContentDashboardItemSubtypeFactory;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.GroupLocalService;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Cristina González
 */
@Component(service = ContentDashboardItemSubtypeFactory.class)
public class DDMStructureContentDashboardItemSubtypeFactory
	implements ContentDashboardItemSubtypeFactory<DDMStructure> {

	@Override
	public ContentDashboardItemSubtype<DDMStructure> create(
			long classPK, long entryClassPK)
		throws PortalException {

		DDMStructure ddmStructure = _ddmStructureLocalService.getStructure(
			classPK);

		return new DDMStructureContentDashboardItemSubtype(
			ddmStructure,
			_groupLocalService.fetchGroup(ddmStructure.getGroupId()));
	}

	@Reference
	private DDMStructureLocalService _ddmStructureLocalService;

	@Reference
	private GroupLocalService _groupLocalService;

}