/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.content.dashboard.journal.internal.item.action;

import com.liferay.content.dashboard.item.action.ContentDashboardItemAction;
import com.liferay.info.display.url.provider.InfoEditURLProvider;
import com.liferay.journal.model.JournalArticle;
import com.liferay.petra.string.StringPool;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.servlet.DynamicServletRequestUtil;

import java.util.Collections;
import java.util.Locale;
import java.util.Optional;

import javax.servlet.http.HttpServletRequest;

/**
 * @author Cristina González
 */
public class EditJournalArticleContentDashboardItemAction
	implements ContentDashboardItemAction {

	public EditJournalArticleContentDashboardItemAction(
		InfoEditURLProvider<JournalArticle> infoEditURLProvider,
		HttpServletRequest httpServletRequest, JournalArticle journalArticle,
		Language language, Portal portal,
		PortletLocalService portletLocalService) {

		_infoEditURLProvider = infoEditURLProvider;
		_httpServletRequest = httpServletRequest;
		_journalArticle = journalArticle;
		_language = language;
		_portal = portal;
		_portletLocalService = portletLocalService;
	}

	@Override
	public String getIcon() {
		return "pencil";
	}

	@Override
	public String getLabel(Locale locale) {
		return _language.get(locale, "edit");
	}

	@Override
	public String getName() {
		return "edit";
	}

	@Override
	public Type getType() {
		return Type.EDIT;
	}

	@Override
	public String getURL() {
		Portlet portlet = _portletLocalService.getPortletById(
			_portal.getPortletId(_httpServletRequest));

		HttpServletRequest httpServletRequest =
			DynamicServletRequestUtil.createDynamicServletRequest(
				_httpServletRequest, portlet,
				Collections.singletonMap(
					"redirect",
					new String[] {_portal.getCurrentURL(_httpServletRequest)}),
				true);

		try {
			return Optional.ofNullable(
				_infoEditURLProvider.getURL(_journalArticle, httpServletRequest)
			).orElse(
				StringPool.BLANK
			);
		}
		catch (Exception exception) {
			_log.error(exception);

			return StringPool.BLANK;
		}
	}

	@Override
	public String getURL(Locale locale) {
		return getURL();
	}

	private static final Log _log = LogFactoryUtil.getLog(
		EditJournalArticleContentDashboardItemAction.class);

	private final HttpServletRequest _httpServletRequest;
	private final InfoEditURLProvider<JournalArticle> _infoEditURLProvider;
	private final JournalArticle _journalArticle;
	private final Language _language;
	private final Portal _portal;
	private final PortletLocalService _portletLocalService;

}