/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.content.dashboard.journal.internal.item;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.content.dashboard.item.ContentDashboardItem;
import com.liferay.content.dashboard.item.ContentDashboardItemFactory;
import com.liferay.content.dashboard.item.action.ContentDashboardItemActionProviderTracker;
import com.liferay.content.dashboard.item.type.ContentDashboardItemSubtypeFactory;
import com.liferay.content.dashboard.item.type.ContentDashboardItemSubtypeFactoryTracker;
import com.liferay.content.dashboard.journal.internal.item.JournalArticleContentDashboardItem;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.info.item.InfoItemServiceTracker;
import com.liferay.info.item.provider.InfoItemFieldValuesProvider;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.journal.service.JournalArticleService;
import com.liferay.portal.kernel.exception.NoSuchModelException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Portal;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ContentDashboardItemFactory.class})
public class JournalArticleContentDashboardItemFactory
implements ContentDashboardItemFactory<JournalArticle> {
    @Reference
    protected InfoItemServiceTracker infoItemServiceTracker;
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private ContentDashboardItemActionProviderTracker _contentDashboardItemActionProviderTracker;
    @Reference
    private ContentDashboardItemSubtypeFactoryTracker _contentDashboardItemSubtypeFactoryTracker;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private JournalArticleLocalService _journalArticleLocalService;
    @Reference
    private JournalArticleService _journalArticleService;
    @Reference
    private Language _language;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    public ContentDashboardItem<JournalArticle> create(long classPK) throws PortalException {
        JournalArticle journalArticle = this._journalArticleLocalService.getLatestArticle(classPK, -1, false);
        AssetEntry assetEntry = null;
        assetEntry = !journalArticle.isApproved() && !journalArticle.isExpired() && journalArticle.getVersion() != 1.0 ? this._assetEntryLocalService.fetchEntry(JournalArticle.class.getName(), journalArticle.getPrimaryKey()) : this._assetEntryLocalService.fetchEntry(JournalArticle.class.getName(), journalArticle.getResourcePrimKey());
        if (assetEntry == null) {
            throw new NoSuchModelException("Unable to find an asset entry for journal article " + journalArticle.getPrimaryKey());
        }
        Optional<ContentDashboardItemSubtypeFactory> contentDashboardItemSubtypeFactoryOptional = this.getContentDashboardItemSubtypeFactoryOptional();
        ContentDashboardItemSubtypeFactory contentDashboardItemSubtypeFactory = contentDashboardItemSubtypeFactoryOptional.orElseThrow(NoSuchModelException::new);
        DDMStructure ddmStructure = journalArticle.getDDMStructure();
        InfoItemFieldValuesProvider infoItemFieldValuesProvider = (InfoItemFieldValuesProvider)this.infoItemServiceTracker.getFirstInfoItemService(InfoItemFieldValuesProvider.class, JournalArticle.class.getName());
        JournalArticle latestApprovedJournalArticle = this._journalArticleLocalService.fetchLatestArticle(classPK, 0);
        return new JournalArticleContentDashboardItem(assetEntry.getCategories(), assetEntry.getTags(), this._contentDashboardItemActionProviderTracker, contentDashboardItemSubtypeFactory.create(ddmStructure.getStructureId(), journalArticle.getResourcePrimKey()), this._groupLocalService.fetchGroup(journalArticle.getGroupId()), (InfoItemFieldValuesProvider<JournalArticle>)infoItemFieldValuesProvider, journalArticle, this._journalArticleService, this._language, latestApprovedJournalArticle, this._portal);
    }

    public Optional<ContentDashboardItemSubtypeFactory> getContentDashboardItemSubtypeFactoryOptional() {
        return this._contentDashboardItemSubtypeFactoryTracker.getContentDashboardItemSubtypeFactoryOptional(DDMStructure.class.getName());
    }
}

