/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.client.extension.util.spring.boot3.service;

import java.net.URI;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.resources.ConnectionProvider;

public abstract class BaseService {
    @Value(value="${com.liferay.lxc.dxp.mainDomain}")
    protected String lxcDXPMainDomain;
    @Value(value="${com.liferay.lxc.dxp.server.protocol}")
    protected String lxcDXPServerProtocol;

    protected Disposable asyncDelete(String body, Map<String, String> httpHeadersMap, URI uri) {
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this._getWebClient().method(HttpMethod.DELETE).uri(this._getAbsoluteURI(uri))).headers(this._getHttpHeadersConsumer(httpHeadersMap))).bodyValue((Object)body).exchangeToMono(this._getExchangeToMonoFunction()).subscribe();
    }

    protected Disposable asyncDelete(String authorization, String body, URI uri) {
        return this.asyncDelete(body, Collections.singletonMap("Authorization", authorization), uri);
    }

    protected Disposable asyncGet(Map<String, String> httpHeadersMap, URI uri) {
        return this._getWebClient().get().uri(this._getAbsoluteURI(uri)).headers(this._getHttpHeadersConsumer(httpHeadersMap)).exchangeToMono(this._getExchangeToMonoFunction()).subscribe();
    }

    protected Disposable asyncGet(String authorization, URI uri) {
        return this.asyncGet(Collections.singletonMap("Authorization", authorization), uri);
    }

    protected Disposable asyncPatch(String body, Map<String, String> httpHeadersMap, URI uri) {
        return ((WebClient.RequestBodySpec)this._getWebClient().patch().uri(this._getAbsoluteURI(uri))).bodyValue((Object)body).headers(this._getHttpHeadersConsumer(httpHeadersMap)).exchangeToMono(this._getExchangeToMonoFunction()).subscribe();
    }

    protected Disposable asyncPatch(String authorization, String body, URI uri) {
        return this.asyncPatch(body, Collections.singletonMap("Authorization", authorization), uri);
    }

    protected Disposable asyncPost(String body, Map<String, String> httpHeadersMap, URI uri) {
        return ((WebClient.RequestBodySpec)this._getWebClient().post().uri(this._getAbsoluteURI(uri))).bodyValue((Object)body).headers(this._getHttpHeadersConsumer(httpHeadersMap)).exchangeToMono(this._getExchangeToMonoFunction()).subscribe();
    }

    protected Disposable asyncPost(String authorization, String body, URI uri) {
        return this.asyncPost(body, Collections.singletonMap("Authorization", authorization), uri);
    }

    protected Disposable asyncPut(String body, Map<String, String> httpHeadersMap, URI uri) {
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this._getWebClient().put().uri(this._getAbsoluteURI(uri))).headers(this._getHttpHeadersConsumer(httpHeadersMap))).bodyValue((Object)body).exchangeToMono(this._getExchangeToMonoFunction()).subscribe();
    }

    protected Disposable asyncPut(String authorization, String body, URI uri) {
        return this.asyncPut(body, Collections.singletonMap("Authorization", authorization), uri);
    }

    protected URI createURI(Object ... objects) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object : objects) {
            stringBuilder.append(object.toString());
        }
        return URI.create(stringBuilder.toString());
    }

    protected String delete(String body, Map<String, String> httpHeadersMap, URI uri) {
        return (String)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this._getWebClient().method(HttpMethod.DELETE).uri(this._getAbsoluteURI(uri))).headers(this._getHttpHeadersConsumer(httpHeadersMap))).bodyValue((Object)body).exchangeToMono(this._getExchangeToMonoFunction()).block();
    }

    protected String delete(String authorization, String body, URI uri) {
        return this.delete(body, Collections.singletonMap("Authorization", authorization), uri);
    }

    protected String get(Map<String, String> httpHeadersMap, URI uri) {
        return (String)this._getWebClient().get().uri(this._getAbsoluteURI(uri)).headers(this._getHttpHeadersConsumer(httpHeadersMap)).exchangeToMono(this._getExchangeToMonoFunction()).block();
    }

    protected String get(String authorization, URI uri) {
        return this.get(Collections.singletonMap("Authorization", authorization), uri);
    }

    protected ExchangeFilterFunction getWebClientExchangeFilterFunction() {
        return (clientRequest, exchangeFunction) -> exchangeFunction.exchange(clientRequest);
    }

    protected void log(Jwt jwt, Log log) {
        if (log.isInfoEnabled()) {
            log.info((Object)("JWT Claims: " + String.valueOf(jwt.getClaims())));
            log.info((Object)("JWT ID: " + jwt.getId()));
            log.info((Object)("JWT Subject: " + jwt.getSubject()));
        }
    }

    protected void log(Jwt jwt, Log log, Map<String, String> parameters) {
        if (log.isInfoEnabled()) {
            log.info((Object)("JWT Claims: " + String.valueOf(jwt.getClaims())));
            log.info((Object)("JWT ID: " + jwt.getId()));
            log.info((Object)("JWT Subject: " + jwt.getSubject()));
            log.info((Object)("Parameters: " + String.valueOf(parameters)));
        }
    }

    protected void log(Jwt jwt, Log log, String json) {
        if (log.isInfoEnabled()) {
            try {
                JSONObject jsonObject = new JSONObject(json);
                log.info((Object)("JSON: " + jsonObject.toString(4)));
            }
            catch (Exception exception) {
                log.error((Object)("JSON: " + json), (Throwable)exception);
            }
            log.info((Object)("JWT Claims: " + String.valueOf(jwt.getClaims())));
            log.info((Object)("JWT ID: " + jwt.getId()));
            log.info((Object)("JWT Subject: " + jwt.getSubject()));
        }
    }

    protected String patch(String body, Map<String, String> httpHeadersMap, URI uri) {
        return (String)((WebClient.RequestBodySpec)this._getWebClient().patch().uri(this._getAbsoluteURI(uri))).bodyValue((Object)body).headers(this._getHttpHeadersConsumer(httpHeadersMap)).exchangeToMono(this._getExchangeToMonoFunction()).block();
    }

    protected String patch(String authorization, String body, URI uri) {
        return this.patch(body, Collections.singletonMap("Authorization", authorization), uri);
    }

    protected String post(String body, Map<String, String> httpHeadersMap, URI uri) {
        return (String)((WebClient.RequestBodySpec)this._getWebClient().post().uri(this._getAbsoluteURI(uri))).bodyValue((Object)body).headers(this._getHttpHeadersConsumer(httpHeadersMap)).exchangeToMono(this._getExchangeToMonoFunction()).block();
    }

    protected String post(String authorization, String body, URI uri) {
        return this.post(body, Collections.singletonMap("Authorization", authorization), uri);
    }

    protected String put(String body, Map<String, String> httpHeadersMap, URI uri) {
        return (String)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this._getWebClient().put().uri(this._getAbsoluteURI(uri))).headers(this._getHttpHeadersConsumer(httpHeadersMap))).bodyValue((Object)body).exchangeToMono(this._getExchangeToMonoFunction()).block();
    }

    protected String put(String authorization, String body, URI uri) {
        return this.put(body, Collections.singletonMap("Authorization", authorization), uri);
    }

    private URI _getAbsoluteURI(URI uri) {
        if (uri.isAbsolute()) {
            return uri;
        }
        URI baseURI = URI.create(this.lxcDXPServerProtocol + "://" + this.lxcDXPMainDomain);
        return baseURI.resolve(uri);
    }

    private Function<ClientResponse, Mono<String>> _getExchangeToMonoFunction() {
        return clientResponse -> {
            HttpStatusCode httpStatusCode = clientResponse.statusCode();
            if (Objects.equals(httpStatusCode, HttpStatus.NO_CONTENT)) {
                return Mono.just((Object)"{}");
            }
            if (httpStatusCode.is2xxSuccessful()) {
                return clientResponse.bodyToMono(String.class);
            }
            if (httpStatusCode.is4xxClientError() || httpStatusCode.is5xxServerError()) {
                return clientResponse.bodyToMono(String.class).flatMap(body -> Mono.error((Throwable)new WebClientResponseException(httpStatusCode.value(), HttpStatus.resolve((int)httpStatusCode.value()).getReasonPhrase(), clientResponse.headers().asHttpHeaders(), body.getBytes(), null)));
            }
            Mono mono = clientResponse.createException();
            return mono.flatMap(Mono::error);
        };
    }

    private Consumer<HttpHeaders> _getHttpHeadersConsumer(Map<String, String> httpHeadersMap) {
        if (httpHeadersMap == null) {
            return httpHeadersConsumer -> httpHeadersConsumer.setAll(new HashMap());
        }
        return httpHeadersConsumer -> httpHeadersConsumer.setAll(httpHeadersMap);
    }

    private WebClient _getWebClient() {
        ConnectionProvider connectionProvider = ((ConnectionProvider.Builder)((ConnectionProvider.Builder)((ConnectionProvider.Builder)((ConnectionProvider.Builder)((ConnectionProvider.Builder)ConnectionProvider.builder((String)"fixed").evictInBackground(Duration.ofSeconds(120L))).maxConnections(500)).maxIdleTime(Duration.ofSeconds(20L))).maxLifeTime(Duration.ofSeconds(60L))).pendingAcquireTimeout(Duration.ofSeconds(60L))).build();
        return WebClient.builder().clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(HttpClient.create((ConnectionProvider)connectionProvider))).defaultHeader("Accept", new String[]{"application/json"}).defaultHeader("Content-Type", new String[]{"application/json"}).exchangeStrategies(ExchangeStrategies.builder().codecs(clientCodecConfigurer -> clientCodecConfigurer.defaultCodecs().maxInMemorySize(0x1000000)).build()).filter(this.getWebClientExchangeFilterFunction()).build();
    }
}

