/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.client.extension.util.spring.boot3;

import com.liferay.client.extension.util.spring.boot3.LiferayOAuth2Util;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.proc.DefaultJOSEObjectTypeVerifier;
import com.nimbusds.jose.proc.JOSEObjectTypeVerifier;
import com.nimbusds.jose.proc.JWSAlgorithmFamilyJWSKeySelector;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.nimbusds.jwt.proc.JWTProcessor;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.resource.OAuth2ResourceServerConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.oauth2.core.DelegatingOAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidatorResult;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.security.web.SecurityFilterChain;

@Configuration
@EnableWebSecurity
public class LiferayOAuth2ResourceServerEnableWebSecurity {
    private static final Log _log = LogFactory.getLog(LiferayOAuth2ResourceServerEnableWebSecurity.class);
    @Autowired
    private Environment _environment;
    @Value(value="${liferay.oauth.urls.excludes:}")
    private String[] _liferayOauthURLsExcludes;
    @Value(value="${com.liferay.lxc.dxp.domains}")
    private String _lxcDXPDomains;
    @Value(value="${com.liferay.lxc.dxp.mainDomain}")
    private String _lxcDXPMainDomain;
    @Value(value="${com.liferay.lxc.dxp.server.protocol}")
    private String _lxcDXPServerProtocol;

    @Bean
    public JwtDecoder jwtDecoder() throws Exception {
        String liferayOauthApplicationExternalReferenceCodes = this._environment.getProperty("liferay.oauth.application.external.reference.codes");
        if (liferayOauthApplicationExternalReferenceCodes == null) {
            throw new IllegalArgumentException("Property \"liferay.oauth.application.external.reference.codes\" is not defined");
        }
        DefaultJWTProcessor defaultJWTProcessor = new DefaultJWTProcessor();
        URL jwkSetURL = new URL(this._lxcDXPServerProtocol + "://" + this._lxcDXPMainDomain + "/o/oauth2/jwks");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Using " + String.valueOf(jwkSetURL)));
        }
        defaultJWTProcessor.setJWSKeySelector((JWSKeySelector)JWSAlgorithmFamilyJWSKeySelector.fromJWKSetURL((URL)jwkSetURL));
        defaultJWTProcessor.setJWSTypeVerifier((JOSEObjectTypeVerifier)new DefaultJOSEObjectTypeVerifier(new JOSEObjectType[]{new JOSEObjectType("at+jwt")}));
        NimbusJwtDecoder nimbusJwtDecoder = new NimbusJwtDecoder((JWTProcessor)defaultJWTProcessor);
        HashMap<String, String> clientIds = new HashMap<String, String>();
        for (String externalReferenceCode : liferayOauthApplicationExternalReferenceCodes.split(",")) {
            String clientId = this._environment.getProperty(externalReferenceCode + ".oauth2.user.agent.client.id");
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Client ID " + clientId));
            }
            clientIds.put(externalReferenceCode, clientId);
        }
        nimbusJwtDecoder.setJwtValidator((OAuth2TokenValidator)new DelegatingOAuth2TokenValidator(new OAuth2TokenValidator[]{new LiferayOAuth2TokenValidator(clientIds)}));
        return nimbusJwtDecoder;
    }

    @Bean
    public SecurityFilterChain securityFilterChain(HttpSecurity httpSecurity) throws Exception {
        return (SecurityFilterChain)((HttpSecurity)((HttpSecurity)((HttpSecurity)httpSecurity.cors().and()).csrf().disable()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).authorizeHttpRequests(customizer -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)customizer.requestMatchers(this._liferayOauthURLsExcludes)).permitAll().anyRequest()).authenticated()).oauth2ResourceServer(OAuth2ResourceServerConfigurer::jwt).build();
    }

    private class LiferayOAuth2TokenValidator
    implements OAuth2TokenValidator<Jwt> {
        private final Map<String, String> _clientIds;
        private final OAuth2Error _oAuth2Error = new OAuth2Error("invalid_token", "The client_id does not match", null);

        public OAuth2TokenValidatorResult validate(Jwt jwt) {
            String jwtClientId = jwt.getClaimAsString("client_id");
            if (this._clientIds.containsValue(jwtClientId)) {
                return OAuth2TokenValidatorResult.success();
            }
            this._clientIds.forEach((externalReferenceCode, clientId) -> this._clientIds.computeIfAbsent((String)externalReferenceCode, key -> LiferayOAuth2Util.getClientId(key, LiferayOAuth2ResourceServerEnableWebSecurity.this._lxcDXPMainDomain, LiferayOAuth2ResourceServerEnableWebSecurity.this._lxcDXPServerProtocol)));
            if (this._clientIds.containsValue(jwtClientId)) {
                return OAuth2TokenValidatorResult.success();
            }
            return OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{this._oAuth2Error});
        }

        private LiferayOAuth2TokenValidator(Map<String, String> clientIds) {
            this._clientIds = clientIds;
        }
    }
}

