/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.client.extension.util.spring.boot2.service;

import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.resources.ConnectionProvider;

public abstract class BaseService {
    @Value(value="${com.liferay.lxc.dxp.mainDomain}")
    protected String lxcDXPMainDomain;
    @Value(value="${com.liferay.lxc.dxp.server.protocol}")
    protected String lxcDXPServerProtocol;

    protected Disposable asyncDelete(String authorization, String body, String path) {
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this._getWebClient().method(HttpMethod.DELETE).uri(path, new Object[0])).header("Authorization", new String[]{authorization})).bodyValue((Object)body).exchangeToMono(this._getExchangeToMonoFunction()).subscribe();
    }

    protected Disposable asyncGet(String authorization, String path) {
        return this._getWebClient().get().uri(path, new Object[0]).header("Authorization", new String[]{authorization}).exchangeToMono(this._getExchangeToMonoFunction()).subscribe();
    }

    protected Disposable asyncPatch(String authorization, String body, String path) {
        return ((WebClient.RequestBodySpec)this._getWebClient().patch().uri(path, new Object[0])).bodyValue((Object)body).header("Authorization", new String[]{authorization}).exchangeToMono(this._getExchangeToMonoFunction()).subscribe();
    }

    protected Disposable asyncPost(String authorization, String body, String path) {
        return ((WebClient.RequestBodySpec)this._getWebClient().post().uri(path, new Object[0])).bodyValue((Object)body).header("Authorization", new String[]{authorization}).exchangeToMono(this._getExchangeToMonoFunction()).subscribe();
    }

    protected Disposable asyncPut(String authorization, String body, String path) {
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this._getWebClient().put().uri(path, new Object[0])).header("Authorization", new String[]{authorization})).bodyValue((Object)body).exchangeToMono(this._getExchangeToMonoFunction()).subscribe();
    }

    protected String delete(String authorization, String body, String path) {
        return (String)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this._getWebClient().method(HttpMethod.DELETE).uri(path, new Object[0])).header("Authorization", new String[]{authorization})).bodyValue((Object)body).exchangeToMono(this._getExchangeToMonoFunction()).block();
    }

    protected String get(String authorization, String path) {
        return (String)this._getWebClient().get().uri(path, new Object[0]).header("Authorization", new String[]{authorization}).exchangeToMono(this._getExchangeToMonoFunction()).block();
    }

    protected String getWebClientBaseURL() {
        return this.lxcDXPServerProtocol + "://" + this.lxcDXPMainDomain;
    }

    protected ExchangeFilterFunction getWebClientExchangeFilterFunction() {
        return (clientRequest, exchangeFunction) -> exchangeFunction.exchange(clientRequest);
    }

    protected void log(Jwt jwt, Log log) {
        if (log.isInfoEnabled()) {
            log.info((Object)("JWT Claims: " + jwt.getClaims()));
            log.info((Object)("JWT ID: " + jwt.getId()));
            log.info((Object)("JWT Subject: " + jwt.getSubject()));
        }
    }

    protected void log(Jwt jwt, Log log, Map<String, String> parameters) {
        if (log.isInfoEnabled()) {
            log.info((Object)("JWT Claims: " + jwt.getClaims()));
            log.info((Object)("JWT ID: " + jwt.getId()));
            log.info((Object)("JWT Subject: " + jwt.getSubject()));
            log.info((Object)("Parameters: " + parameters));
        }
    }

    protected void log(Jwt jwt, Log log, String json) {
        if (log.isInfoEnabled()) {
            try {
                JSONObject jsonObject = new JSONObject(json);
                log.info((Object)("JSON: " + jsonObject.toString(4)));
            }
            catch (Exception exception) {
                log.error((Object)("JSON: " + json), (Throwable)exception);
            }
            log.info((Object)("JWT Claims: " + jwt.getClaims()));
            log.info((Object)("JWT ID: " + jwt.getId()));
            log.info((Object)("JWT Subject: " + jwt.getSubject()));
        }
    }

    protected String patch(String authorization, String body, String path) {
        return (String)((WebClient.RequestBodySpec)this._getWebClient().patch().uri(path, new Object[0])).bodyValue((Object)body).header("Authorization", new String[]{authorization}).exchangeToMono(this._getExchangeToMonoFunction()).block();
    }

    protected String post(String authorization, String body, String path) {
        return (String)((WebClient.RequestBodySpec)this._getWebClient().post().uri(path, new Object[0])).bodyValue((Object)body).header("Authorization", new String[]{authorization}).exchangeToMono(this._getExchangeToMonoFunction()).block();
    }

    protected String put(String authorization, String body, String path) {
        return (String)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this._getWebClient().put().uri(path, new Object[0])).header("Authorization", new String[]{authorization})).bodyValue((Object)body).exchangeToMono(this._getExchangeToMonoFunction()).block();
    }

    private Function<ClientResponse, Mono<String>> _getExchangeToMonoFunction() {
        return clientResponse -> {
            HttpStatus httpStatus = clientResponse.statusCode();
            if (Objects.equals(clientResponse.statusCode(), HttpStatus.NO_CONTENT)) {
                return Mono.just((Object)"{}");
            }
            if (httpStatus.is2xxSuccessful()) {
                return clientResponse.bodyToMono(String.class);
            }
            if (httpStatus.is4xxClientError() || httpStatus.is5xxServerError()) {
                return clientResponse.bodyToMono(String.class).flatMap(body -> Mono.error((Throwable)new WebClientResponseException(httpStatus.value(), httpStatus.getReasonPhrase(), clientResponse.headers().asHttpHeaders(), body.getBytes(), null)));
            }
            Mono mono = clientResponse.createException();
            return mono.flatMap(Mono::error);
        };
    }

    private WebClient _getWebClient() {
        ConnectionProvider connectionProvider = ((ConnectionProvider.Builder)((ConnectionProvider.Builder)((ConnectionProvider.Builder)((ConnectionProvider.Builder)((ConnectionProvider.Builder)ConnectionProvider.builder((String)"fixed").evictInBackground(Duration.ofSeconds(120L))).maxConnections(500)).maxIdleTime(Duration.ofSeconds(20L))).maxLifeTime(Duration.ofSeconds(60L))).pendingAcquireTimeout(Duration.ofSeconds(60L))).build();
        return WebClient.builder().clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(HttpClient.create((ConnectionProvider)connectionProvider))).baseUrl(this.getWebClientBaseURL()).defaultHeader("Accept", new String[]{"application/json"}).defaultHeader("Content-Type", new String[]{"application/json"}).exchangeStrategies(ExchangeStrategies.builder().codecs(clientCodecConfigurer -> clientCodecConfigurer.defaultCodecs().maxInMemorySize(0x1000000)).build()).filter(this.getWebClientExchangeFilterFunction()).build();
    }
}

