/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.writer;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.fasterxml.jackson.databind.util.ISO8601DateFormat;
import com.liferay.portal.vulcan.jackson.databind.ser.VulcanPropertyFilter;
import java.text.DateFormat;
import java.util.HashSet;
import java.util.List;

public class ObjectWriterFactory {
    private static final ObjectMapper _objectMapper = new ObjectMapper(){
        {
            this.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            this.enable(new MapperFeature[]{MapperFeature.SORT_PROPERTIES_ALPHABETICALLY});
            this.enable(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS);
            this.setDateFormat((DateFormat)new ISO8601DateFormat());
            this.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        }
    };

    public static ObjectWriter getObjectWriter(List<String> includeFieldNames) {
        SimpleFilterProvider simpleFilterProvider = new SimpleFilterProvider();
        if (includeFieldNames.isEmpty()) {
            simpleFilterProvider.setFailOnUnknownId(false);
        } else {
            simpleFilterProvider.addFilter("Liferay.Vulcan", (SimpleBeanPropertyFilter)VulcanPropertyFilter.of(new HashSet<String>(includeFieldNames), null));
        }
        return _objectMapper.writer((FilterProvider)simpleFilterProvider);
    }
}

