/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.reader;

import com.liferay.batch.engine.BatchEngineTaskContentType;
import com.liferay.batch.engine.internal.reader.BatchEngineImportTaskItemReader;
import com.liferay.batch.engine.internal.reader.CSVBatchEngineImportTaskItemReaderImpl;
import com.liferay.batch.engine.internal.reader.JSONBatchEngineImportTaskItemReaderImpl;
import com.liferay.batch.engine.internal.reader.JSONLBatchEngineImportTaskItemReaderImpl;
import com.liferay.batch.engine.internal.reader.XLSBatchEngineImportTaskItemReaderImpl;
import com.liferay.batch.engine.internal.util.ZipInputStreamUtil;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Map;

public class BatchEngineImportTaskItemReaderFactory {
    public BatchEngineImportTaskItemReader create(BatchEngineTaskContentType batchEngineTaskContentType, String csvFileColumnDelimiter, InputStream inputStream, Map<String, Serializable> parameters) throws Exception {
        inputStream = ZipInputStreamUtil.asZipInputStream(inputStream);
        if (batchEngineTaskContentType == BatchEngineTaskContentType.CSV) {
            return new CSVBatchEngineImportTaskItemReaderImpl(csvFileColumnDelimiter, inputStream, parameters);
        }
        if (batchEngineTaskContentType == BatchEngineTaskContentType.JSON || batchEngineTaskContentType == BatchEngineTaskContentType.JSONT) {
            return new JSONBatchEngineImportTaskItemReaderImpl(inputStream);
        }
        if (batchEngineTaskContentType == BatchEngineTaskContentType.JSONL) {
            return new JSONLBatchEngineImportTaskItemReaderImpl(inputStream);
        }
        if (batchEngineTaskContentType == BatchEngineTaskContentType.XLS || batchEngineTaskContentType == BatchEngineTaskContentType.XLSX) {
            return new XLSBatchEngineImportTaskItemReaderImpl(inputStream);
        }
        throw new IllegalArgumentException("Unknown batch engine task content type " + batchEngineTaskContentType);
    }
}

