/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.auto.deploy;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.batch.engine.internal.auto.deploy.BatchEngineZipUnit;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassicBatchEngineZipUnitImpl<T>
implements BatchEngineZipUnit<T> {
    private ZipEntry _configurationZipEntry;
    private ZipEntry _dataZipEntry;
    private final ZipFile _zipFile;

    public ClassicBatchEngineZipUnitImpl(ZipFile zipFile, ZipEntry ... zipEntries) {
        if (zipEntries == null || zipEntries.length > 2) {
            throw new IllegalArgumentException("Invalid zip entries " + zipEntries);
        }
        this._zipFile = Objects.requireNonNull(zipFile);
        for (ZipEntry zipEntry : zipEntries) {
            if (this._isBatchEngineConfiguration(zipEntry.getName())) {
                this._configurationZipEntry = zipEntry;
                continue;
            }
            this._dataZipEntry = zipEntry;
        }
        if (Objects.isNull(this._configurationZipEntry)) {
            throw new IllegalArgumentException("Configuration zip entry is null");
        }
        if (Objects.isNull(this._dataZipEntry)) {
            throw new IllegalArgumentException("Data zip entry is null");
        }
    }

    @Override
    public T getBatchEngineConfiguration(Class<T> clazz) throws IOException {
        try (InputStream inputStream = this._zipFile.getInputStream(this._configurationZipEntry);){
            ObjectMapper objectMapper = new ObjectMapper();
            Object object = objectMapper.readValue(inputStream, clazz);
            return (T)object;
        }
    }

    @Override
    public InputStream getConfigurationInputStream() throws IOException {
        return this._zipFile.getInputStream(this._configurationZipEntry);
    }

    @Override
    public String getDataFileName() {
        return this._dataZipEntry.getName();
    }

    @Override
    public InputStream getDataInputStream() throws IOException {
        return this._zipFile.getInputStream(this._dataZipEntry);
    }

    @Override
    public String getZipFileName() {
        return this._zipFile.getName();
    }

    @Override
    public boolean isValid() {
        return this._configurationZipEntry != null && this._dataZipEntry != null;
    }

    private boolean _isBatchEngineConfiguration(String zipEntryName) {
        return Objects.equals(zipEntryName, "batch-engine.json") || zipEntryName.endsWith("/batch-engine.json");
    }
}

