/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.auto.deploy;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.batch.engine.BatchEngineImportTaskExecutor;
import com.liferay.batch.engine.BatchEngineTaskExecuteStatus;
import com.liferay.batch.engine.BatchEngineTaskOperation;
import com.liferay.batch.engine.internal.auto.deploy.AdvancedBatchEngineZipUnitImpl;
import com.liferay.batch.engine.internal.auto.deploy.BatchEngineZipUnit;
import com.liferay.batch.engine.internal.auto.deploy.ClassicBatchEngineZipUnitImpl;
import com.liferay.batch.engine.model.BatchEngineImportTask;
import com.liferay.batch.engine.service.BatchEngineImportTaskLocalService;
import com.liferay.petra.concurrent.NoticeableExecutorService;
import com.liferay.petra.executor.PortalExecutorManager;
import com.liferay.petra.io.StreamUtil;
import com.liferay.petra.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.deploy.auto.AutoDeployException;
import com.liferay.portal.kernel.deploy.auto.AutoDeployListener;
import com.liferay.portal.kernel.deploy.auto.context.AutoDeploymentContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={AutoDeployListener.class})
public class BatchEngineAutoDeployListener
implements AutoDeployListener {
    private static final Log _log = LogFactoryUtil.getLog(BatchEngineAutoDeployListener.class);
    @Reference
    private BatchEngineImportTaskExecutor _batchEngineImportTaskExecutor;
    @Reference
    private BatchEngineImportTaskLocalService _batchEngineImportTaskLocalService;
    @Reference
    private com.liferay.portal.kernel.util.File _file;
    @Reference
    private PortalExecutorManager _portalExecutorManager;

    public int deploy(AutoDeploymentContext autoDeploymentContext) throws AutoDeployException {
        try (ZipFile zipFile = new ZipFile(autoDeploymentContext.getFile());){
            this._deploy(zipFile);
        }
        catch (Exception exception) {
            throw new AutoDeployException((Throwable)exception);
        }
        return 1;
    }

    public boolean isBatchEngineTechnical(String zipEntryName) {
        return zipEntryName.endsWith("jsont");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isDeployable(AutoDeploymentContext autoDeploymentContext) throws AutoDeployException {
        File file = autoDeploymentContext.getFile();
        String fileName = file.getName();
        if (!StringUtil.endsWith((String)fileName, (String)".zip")) {
            return false;
        }
        try (ZipFile zipFile = new ZipFile(file);){
            BatchEngineImportConfiguration batchEngineImportConfiguration;
            BatchEngineZipUnit batchEngineZipUnit;
            Iterator<BatchEngineZipUnit> iterator = this._getBatchEngineZipUnits(zipFile).iterator();
            do {
                if (!iterator.hasNext()) return false;
            } while (!(batchEngineZipUnit = iterator.next()).isValid() || (batchEngineImportConfiguration = this._getBatchEngineImportConfiguration(batchEngineZipUnit)) == null || batchEngineImportConfiguration.companyId <= 0L || batchEngineImportConfiguration.userId <= 0L || !Validator.isNotNull((String)batchEngineImportConfiguration.className) || !Validator.isNotNull((String)batchEngineImportConfiguration.version));
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            throw new AutoDeployException((Throwable)exception);
        }
    }

    private void _deploy(ZipFile zipFile) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Deploying batch engine file " + zipFile.getName()));
        }
        for (BatchEngineZipUnit batchEngineZipUnit : this._getBatchEngineZipUnits(zipFile)) {
            this._processBatchEngineZipUnit(batchEngineZipUnit);
        }
    }

    private BatchEngineImportConfiguration _getBatchEngineImportConfiguration(BatchEngineZipUnit<BatchEngineImportConfiguration> batchEngineZipUnit) throws IOException {
        return batchEngineZipUnit.getBatchEngineConfiguration(BatchEngineImportConfiguration.class);
    }

    private String _getBatchEngineZipEntryKey(ZipEntry zipEntry) {
        String zipEntryName = zipEntry.getName();
        if (this.isBatchEngineTechnical(zipEntryName)) {
            return zipEntryName;
        }
        if (!zipEntryName.contains("/")) {
            return "";
        }
        return zipEntryName.substring(0, zipEntryName.lastIndexOf("/"));
    }

    private Iterable<BatchEngineZipUnit> _getBatchEngineZipUnits(final ZipFile zipFile) {
        return new Iterable<BatchEngineZipUnit>(){

            @Override
            public Iterator<BatchEngineZipUnit> iterator() {
                return new BatchEngineZipUnitIterator(zipFile);
            }
        };
    }

    private Collection<BatchEngineZipUnit> _getBatchEngineZipUnitsCollection(ZipFile zipFile) {
        HashMap<String, ZipEntry> batchEngineZipEntries = new HashMap<String, ZipEntry>();
        HashMap batchEngineZipUnits = new HashMap();
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory()) continue;
            String key = this._getBatchEngineZipEntryKey(zipEntry);
            ZipEntry complementZipEntry = (ZipEntry)batchEngineZipEntries.get(key);
            if (complementZipEntry == null) {
                batchEngineZipEntries.put(key, zipEntry);
                batchEngineZipUnits.put(key, new AdvancedBatchEngineZipUnitImpl(zipFile, zipEntry));
                continue;
            }
            batchEngineZipUnits.put(key, new ClassicBatchEngineZipUnitImpl(zipFile, zipEntry, complementZipEntry));
            batchEngineZipEntries.remove(key);
        }
        return batchEngineZipUnits.values();
    }

    private void _processBatchEngineZipUnit(BatchEngineZipUnit<BatchEngineImportConfiguration> batchEngineZipUnit) throws Exception {
        BatchEngineImportConfiguration batchEngineImportConfiguration = null;
        byte[] content = null;
        String contentType = null;
        if (batchEngineZipUnit.isValid()) {
            batchEngineImportConfiguration = batchEngineZipUnit.getBatchEngineConfiguration(BatchEngineImportConfiguration.class);
            UnsyncByteArrayOutputStream compressedUnsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
            try (InputStream inputStream = batchEngineZipUnit.getDataInputStream();
                 ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)compressedUnsyncByteArrayOutputStream);){
                zipOutputStream.putNextEntry(new ZipEntry(batchEngineZipUnit.getDataFileName()));
                StreamUtil.transfer((InputStream)inputStream, (OutputStream)zipOutputStream, (boolean)false);
            }
            content = compressedUnsyncByteArrayOutputStream.toByteArray();
            contentType = this._file.getExtension(batchEngineZipUnit.getDataFileName());
        }
        if (batchEngineImportConfiguration == null || content == null || Validator.isNull(contentType)) {
            throw new IllegalStateException("Invalid batch engine file " + batchEngineZipUnit.getZipFileName());
        }
        NoticeableExecutorService executorService = this._portalExecutorManager.getPortalExecutor(BatchEngineAutoDeployListener.class.getName());
        BatchEngineImportTask batchEngineImportTask = this._batchEngineImportTaskLocalService.addBatchEngineImportTask(null, batchEngineImportConfiguration.companyId, batchEngineImportConfiguration.userId, 100L, batchEngineImportConfiguration.callbackURL, batchEngineImportConfiguration.className, content, StringUtil.toUpperCase(contentType), BatchEngineTaskExecuteStatus.INITIAL.name(), batchEngineImportConfiguration.fieldNameMappingMap, 2, BatchEngineTaskOperation.CREATE.name(), batchEngineImportConfiguration.parameters, batchEngineImportConfiguration.taskItemDelegateName);
        executorService.submit(() -> {
            this._batchEngineImportTaskExecutor.execute(batchEngineImportTask);
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Successfully deployed batch engine file " + batchEngineZipUnit.getZipFileName()));
            }
        });
    }

    private class BatchEngineZipUnitIterator
    implements Iterator<BatchEngineZipUnit> {
        private final Iterator<BatchEngineZipUnit> _iterator;

        public BatchEngineZipUnitIterator(ZipFile zipFile) {
            Collection batchEngineZipUnits = BatchEngineAutoDeployListener.this._getBatchEngineZipUnitsCollection(zipFile);
            this._iterator = batchEngineZipUnits.iterator();
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public BatchEngineZipUnit next() {
            return this._iterator.next();
        }
    }

    public static final class BatchEngineImportConfiguration {
        @JsonProperty
        protected String callbackURL;
        @JsonProperty
        protected String className;
        @JsonProperty
        protected long companyId;
        @JsonProperty
        protected Map<String, String> fieldNameMappingMap;
        @JsonProperty
        protected Map<String, Serializable> parameters;
        @JsonProperty
        protected String taskItemDelegateName;
        @JsonProperty
        protected long userId;
        @JsonProperty
        protected String version;
    }
}

