/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.auto.deploy;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class AdvancedJSONReader<T> {
    private final InputStream _inputStream;

    public AdvancedJSONReader(InputStream inputStream) {
        this._inputStream = inputStream;
    }

    public T getObject(String name, Class<T> clazz) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.transferJSONObject(name, byteArrayOutputStream);
        ObjectMapper objectMapper = new ObjectMapper();
        return (T)objectMapper.readValue(byteArrayOutputStream.toByteArray(), clazz);
    }

    public boolean hasKey(String name) throws IOException {
        this._readUntil("\"" + name + "\":");
        return this._inputStream.available() > 0;
    }

    public void transferJSONArray(String name, OutputStream outputStream) throws IOException {
        this._readUntil("\"" + name + "\"");
        this._transferBlock('[', ']', outputStream);
    }

    public void transferJSONObject(String name, OutputStream outputStream) throws IOException {
        this._readUntil("\"" + name + "\"");
        this._transferBlock('{', '}', outputStream);
    }

    private void _readUntil(String expression) throws IOException {
        byte[] bufferTemplate = expression.getBytes();
        byte[] buffer = new byte[bufferTemplate.length];
        int read = this._inputStream.read(buffer);
        while (read > -1 && !Arrays.equals(bufferTemplate, buffer)) {
            for (int i = 1; i < buffer.length; ++i) {
                buffer[i - 1] = buffer[i];
            }
            read = this._inputStream.read(buffer, buffer.length - 1, 1);
        }
    }

    private void _transferBlock(char opener, char closer, OutputStream outputStream) throws IOException {
        int read = -1;
        do {
            if ((read = this._inputStream.read()) != -1) continue;
            throw new IllegalStateException("Unable to find character " + (char)opener);
        } while (read != opener);
        int opened = 0;
        do {
            outputStream.write(read);
            if (read == opener) {
                ++opened;
            }
            if (read == closer) {
                --opened;
            }
            read = this._inputStream.read();
        } while (opened != 0 && read > -1);
    }
}

