/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal;

import com.liferay.batch.engine.BatchEngineImportTaskExecutor;
import com.liferay.batch.engine.BatchEngineTaskContentType;
import com.liferay.batch.engine.BatchEngineTaskExecuteStatus;
import com.liferay.batch.engine.BatchEngineTaskOperation;
import com.liferay.batch.engine.configuration.BatchEngineTaskCompanyConfiguration;
import com.liferay.batch.engine.internal.BatchEngineTaskCallbackUtil;
import com.liferay.batch.engine.internal.BatchEngineTaskExecutorUtil;
import com.liferay.batch.engine.internal.BatchEngineTaskMethodRegistry;
import com.liferay.batch.engine.internal.item.BatchEngineTaskItemDelegateExecutor;
import com.liferay.batch.engine.internal.item.BatchEngineTaskItemDelegateExecutorFactory;
import com.liferay.batch.engine.internal.reader.BatchEngineImportTaskItemReader;
import com.liferay.batch.engine.internal.reader.BatchEngineImportTaskItemReaderFactory;
import com.liferay.batch.engine.internal.reader.BatchEngineImportTaskItemReaderUtil;
import com.liferay.batch.engine.internal.strategy.BatchEngineImportStrategyFactory;
import com.liferay.batch.engine.internal.task.progress.BatchEngineTaskProgress;
import com.liferay.batch.engine.internal.task.progress.BatchEngineTaskProgressFactory;
import com.liferay.batch.engine.internal.util.ItemIndexThreadLocal;
import com.liferay.batch.engine.model.BatchEngineImportTask;
import com.liferay.batch.engine.service.BatchEngineImportTaskErrorLocalService;
import com.liferay.batch.engine.service.BatchEngineImportTaskLocalService;
import com.liferay.petra.function.UnsafeRunnable;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={BatchEngineImportTaskExecutor.class})
public class BatchEngineImportTaskExecutorImpl
implements BatchEngineImportTaskExecutor {
    private static final Log _log = LogFactoryUtil.getLog(BatchEngineImportTaskExecutorImpl.class);
    private static final TransactionConfig _transactionConfig = TransactionConfig.Factory.create((Propagation)Propagation.REQUIRES_NEW, (Class[])new Class[]{Exception.class}, (Class[])new Class[0]);
    private final BatchEngineImportStrategyFactory _batchEngineImportStrategyFactory = new BatchEngineImportStrategyFactory();
    @Reference
    private BatchEngineImportTaskErrorLocalService _batchEngineImportTaskErrorLocalService;
    private final BatchEngineImportTaskItemReaderFactory _batchEngineImportTaskItemReaderFactory = new BatchEngineImportTaskItemReaderFactory();
    @Reference
    private BatchEngineImportTaskLocalService _batchEngineImportTaskLocalService;
    private BatchEngineTaskItemDelegateExecutorFactory _batchEngineTaskItemDelegateExecutorFactory;
    @Reference
    private BatchEngineTaskMethodRegistry _batchEngineTaskMethodRegistry;
    private final BatchEngineTaskProgressFactory _batchEngineTaskProgressFactory = new BatchEngineTaskProgressFactory();
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private UserLocalService _userLocalService;

    public void execute(BatchEngineImportTask batchEngineImportTask) {
        try (SafeCloseable safeCloseable = CompanyThreadLocal.setWithSafeCloseable((Long)batchEngineImportTask.getCompanyId());){
            batchEngineImportTask.setExecuteStatus(BatchEngineTaskExecuteStatus.STARTED.toString());
            batchEngineImportTask.setStartTime(new Date());
            BatchEngineTaskProgress batchEngineTaskProgress = this._batchEngineTaskProgressFactory.create(BatchEngineTaskContentType.valueOf((String)batchEngineImportTask.getContentType()));
            batchEngineImportTask.setTotalItemsCount(batchEngineTaskProgress.getTotalItemsCount(this._batchEngineImportTaskLocalService.openContentInputStream(batchEngineImportTask.getBatchEngineImportTaskId())));
            this._batchEngineImportTaskLocalService.updateBatchEngineImportTask(batchEngineImportTask);
            BatchEngineTaskExecutorUtil.execute((UnsafeRunnable<Throwable>)((UnsafeRunnable)() -> this._importItems(batchEngineImportTask)), this._userLocalService.getUser(batchEngineImportTask.getUserId()));
            this._updateBatchEngineImportTask(BatchEngineTaskExecuteStatus.COMPLETED, batchEngineImportTask, null);
        }
        catch (Throwable throwable) {
            _log.error((Object)("Unable to update batch engine import task " + batchEngineImportTask), throwable);
            this._updateBatchEngineImportTask(BatchEngineTaskExecuteStatus.FAILED, batchEngineImportTask, throwable.toString());
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this._batchEngineTaskItemDelegateExecutorFactory = new BatchEngineTaskItemDelegateExecutorFactory(this._batchEngineTaskMethodRegistry, null, null, null);
    }

    private void _commitItems(BatchEngineImportTask batchEngineImportTask, BatchEngineTaskItemDelegateExecutor batchEngineTaskItemDelegateExecutor, List<Object> items, int processedItemsCount) throws Throwable {
        TransactionInvokerUtil.invoke((TransactionConfig)_transactionConfig, () -> {
            batchEngineTaskItemDelegateExecutor.saveItems(this._batchEngineImportStrategyFactory.create(batchEngineImportTask), BatchEngineTaskOperation.valueOf((String)batchEngineImportTask.getOperation()), items);
            batchEngineImportTask.setProcessedItemsCount(processedItemsCount);
            this._batchEngineImportTaskLocalService.updateBatchEngineImportTask(batchEngineImportTask);
            return null;
        });
    }

    private String _getCSVFileColumnDelimiter(long companyId) throws ConfigurationException {
        BatchEngineTaskCompanyConfiguration batchEngineTaskCompanyConfiguration = (BatchEngineTaskCompanyConfiguration)this._configurationProvider.getCompanyConfiguration(BatchEngineTaskCompanyConfiguration.class, companyId);
        return batchEngineTaskCompanyConfiguration.csvFileColumnDelimiter();
    }

    private Map<String, Serializable> _getParameters(BatchEngineImportTask batchEngineImportTask) {
        HashMap<String, Serializable> parameters = batchEngineImportTask.getParameters();
        if (parameters == null) {
            parameters = new HashMap<String, Serializable>();
        }
        parameters.computeIfAbsent("taskItemDelegateName", key -> batchEngineImportTask.getTaskItemDelegateName());
        return parameters;
    }

    private void _handleException(BatchEngineImportTask batchEngineImportTask, Exception exception, int processedItemsCount) throws Exception {
        this._batchEngineImportTaskErrorLocalService.addBatchEngineImportTaskError(batchEngineImportTask.getCompanyId(), batchEngineImportTask.getUserId(), batchEngineImportTask.getBatchEngineImportTaskId(), null, processedItemsCount, exception.toString());
        if (batchEngineImportTask.getImportStrategy() == 2) {
            throw exception;
        }
    }

    private void _importItems(BatchEngineImportTask batchEngineImportTask) throws Throwable {
        Map<String, Serializable> parameters = this._getParameters(batchEngineImportTask);
        try (BatchEngineImportTaskItemReader batchEngineImportTaskItemReader = this._batchEngineImportTaskItemReaderFactory.create(BatchEngineTaskContentType.valueOf((String)batchEngineImportTask.getContentType()), GetterUtil.getString((String)this._getCSVFileColumnDelimiter(batchEngineImportTask.getCompanyId()), (String)","), this._batchEngineImportTaskLocalService.openContentInputStream(batchEngineImportTask.getBatchEngineImportTaskId()), parameters);
             BatchEngineTaskItemDelegateExecutor batchEngineTaskItemDelegateExecutor = this._batchEngineTaskItemDelegateExecutorFactory.create(batchEngineImportTask.getTaskItemDelegateName(), batchEngineImportTask.getClassName(), this._companyLocalService.getCompany(batchEngineImportTask.getCompanyId()), parameters, this._userLocalService.getUser(batchEngineImportTask.getUserId()));){
            ArrayList<Object> items = new ArrayList<Object>();
            Class itemClass = this._batchEngineTaskMethodRegistry.getItemClass(batchEngineImportTask.getClassName());
            int processedItemsCount = 0;
            while (true) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                try {
                    Object item = this._readItem(batchEngineImportTaskItemReader, batchEngineImportTask.getFieldNameMapping(), itemClass);
                    if (item == null) break;
                    items.add(item);
                    ItemIndexThreadLocal.put(item, ++processedItemsCount);
                }
                catch (Exception exception) {
                    this._handleException(batchEngineImportTask, exception, ++processedItemsCount);
                }
                if ((long)items.size() != batchEngineImportTask.getBatchSize()) continue;
                this._commitItems(batchEngineImportTask, batchEngineTaskItemDelegateExecutor, items, processedItemsCount);
                items.clear();
                ItemIndexThreadLocal.remove();
            }
            if (!items.isEmpty()) {
                this._commitItems(batchEngineImportTask, batchEngineTaskItemDelegateExecutor, items, processedItemsCount);
            }
        }
    }

    private Object _readItem(BatchEngineImportTaskItemReader batchEngineImportTaskItemReader, Map<String, Serializable> fieldNameMapping, Class<?> itemClass) throws Exception {
        Map<String, Object> fieldNameValueMap = batchEngineImportTaskItemReader.read();
        if (fieldNameValueMap == null) {
            return null;
        }
        return BatchEngineImportTaskItemReaderUtil.convertValue(itemClass, BatchEngineImportTaskItemReaderUtil.mapFieldNames(fieldNameMapping, fieldNameValueMap));
    }

    private void _updateBatchEngineImportTask(BatchEngineTaskExecuteStatus batchEngineTaskExecuteStatus, BatchEngineImportTask batchEngineImportTask, String errorMessage) {
        batchEngineImportTask.setEndTime(new Date());
        batchEngineImportTask.setErrorMessage(errorMessage);
        batchEngineImportTask.setExecuteStatus(batchEngineTaskExecuteStatus.toString());
        this._batchEngineImportTaskLocalService.updateBatchEngineImportTask(batchEngineImportTask);
        BatchEngineTaskCallbackUtil.sendCallback(batchEngineImportTask.getCallbackURL(), batchEngineImportTask.getExecuteStatus(), batchEngineImportTask.getBatchEngineImportTaskId());
    }
}

