/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.auto.deploy;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.batch.engine.BatchEngineImportTaskExecutor;
import com.liferay.batch.engine.BatchEngineTaskExecuteStatus;
import com.liferay.batch.engine.BatchEngineTaskOperation;
import com.liferay.batch.engine.model.BatchEngineImportTask;
import com.liferay.batch.engine.service.BatchEngineImportTaskLocalService;
import com.liferay.petra.concurrent.NoticeableExecutorService;
import com.liferay.petra.executor.PortalExecutorManager;
import com.liferay.petra.io.StreamUtil;
import com.liferay.petra.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.deploy.auto.AutoDeployException;
import com.liferay.portal.kernel.deploy.auto.AutoDeployListener;
import com.liferay.portal.kernel.deploy.auto.context.AutoDeploymentContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={AutoDeployListener.class})
public class BatchEngineAutoDeployListener
implements AutoDeployListener {
    private static final Log _log = LogFactoryUtil.getLog(BatchEngineAutoDeployListener.class);
    private static final ObjectMapper _objectMapper = new ObjectMapper();
    @Reference
    private BatchEngineImportTaskExecutor _batchEngineImportTaskExecutor;
    @Reference
    private BatchEngineImportTaskLocalService _batchEngineImportTaskLocalService;
    @Reference
    private com.liferay.portal.kernel.util.File _file;
    @Reference
    private PortalExecutorManager _portalExecutorManager;

    public int deploy(AutoDeploymentContext autoDeploymentContext) throws AutoDeployException {
        try (ZipFile zipFile = new ZipFile(autoDeploymentContext.getFile());){
            this._deploy(zipFile);
        }
        catch (Exception exception) {
            throw new AutoDeployException((Throwable)exception);
        }
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isDeployable(AutoDeploymentContext autoDeploymentContext) throws AutoDeployException {
        File file = autoDeploymentContext.getFile();
        String fileName = file.getName();
        if (!StringUtil.endsWith((String)fileName, (String)".zip")) {
            return false;
        }
        try (ZipFile zipFile = new ZipFile(file);){
            if (!this._isValidZipEntryCount(zipFile)) {
                boolean bl = false;
                return bl;
            }
            BatchEngineZipEntryPair batchEngineZipEntryPair = this._getBatchEngineZipEntryPair(zipFile);
            if (!batchEngineZipEntryPair.isValid()) {
                boolean bl = false;
                return bl;
            }
            try (InputStream inputStream = zipFile.getInputStream(batchEngineZipEntryPair._configurationZipEntry);){
                BatchEngineImportConfiguration batchEngineImportConfiguration = (BatchEngineImportConfiguration)_objectMapper.readValue(inputStream, BatchEngineImportConfiguration.class);
                if (batchEngineImportConfiguration != null && batchEngineImportConfiguration.companyId != 0L && batchEngineImportConfiguration.userId != 0L && !Validator.isNull((String)batchEngineImportConfiguration.className)) {
                    if (!Validator.isNull((String)batchEngineImportConfiguration.version)) return true;
                }
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception exception) {
            throw new AutoDeployException((Throwable)exception);
        }
    }

    private void _deploy(ZipFile zipFile) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Deploying batch engine file " + zipFile.getName()));
        }
        BatchEngineZipEntryPair batchEngineZipEntryPair = this._getBatchEngineZipEntryPair(zipFile);
        BatchEngineImportConfiguration batchEngineImportConfiguration = null;
        byte[] content = null;
        String contentType = null;
        if (batchEngineZipEntryPair.isValid()) {
            try (InputStream inputStream = zipFile.getInputStream(batchEngineZipEntryPair._configurationZipEntry);){
                batchEngineImportConfiguration = (BatchEngineImportConfiguration)_objectMapper.readValue(inputStream, BatchEngineImportConfiguration.class);
            }
            UnsyncByteArrayOutputStream compressedUnsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
            ZipEntry dataZipEntry = batchEngineZipEntryPair._dataZipEntry;
            try (InputStream inputStream = zipFile.getInputStream(dataZipEntry);
                 ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)compressedUnsyncByteArrayOutputStream);){
                zipOutputStream.putNextEntry(new ZipEntry(dataZipEntry.getName()));
                StreamUtil.transfer((InputStream)inputStream, (OutputStream)zipOutputStream, (boolean)false);
            }
            content = compressedUnsyncByteArrayOutputStream.toByteArray();
            contentType = this._file.getExtension(dataZipEntry.getName());
        }
        if (batchEngineImportConfiguration == null || content == null || Validator.isNull(contentType)) {
            throw new IllegalStateException("Invalid batch engine file " + zipFile.getName());
        }
        NoticeableExecutorService executorService = this._portalExecutorManager.getPortalExecutor(BatchEngineAutoDeployListener.class.getName());
        BatchEngineImportTask batchEngineImportTask = this._batchEngineImportTaskLocalService.addBatchEngineImportTask(null, batchEngineImportConfiguration.companyId, batchEngineImportConfiguration.userId, 100L, batchEngineImportConfiguration.callbackURL, batchEngineImportConfiguration.className, content, StringUtil.toUpperCase(contentType), BatchEngineTaskExecuteStatus.INITIAL.name(), batchEngineImportConfiguration.fieldNameMappingMap, 2, BatchEngineTaskOperation.CREATE.name(), batchEngineImportConfiguration.parameters, batchEngineImportConfiguration.taskItemDelegateName);
        executorService.submit(() -> {
            this._batchEngineImportTaskExecutor.execute(batchEngineImportTask);
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Successfully deployed batch engine file " + zipFile.getName()));
            }
        });
    }

    private BatchEngineZipEntryPair _getBatchEngineZipEntryPair(ZipFile zipFile) {
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        BatchEngineZipEntryPair batchEngineZipEntryPair = new BatchEngineZipEntryPair();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory()) continue;
            String zipEntryName = zipEntry.getName();
            if (zipEntryName.contains("batch-engine.json")) {
                batchEngineZipEntryPair.setConfigurationZipEntry(zipEntry);
                continue;
            }
            batchEngineZipEntryPair.setDataZipEntry(zipEntry);
        }
        return batchEngineZipEntryPair;
    }

    private boolean _isValidZipEntryCount(ZipFile zipFile) {
        int count = 0;
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory()) continue;
            ++count;
        }
        if (count != 2) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unsupported file count " + count));
            }
            return false;
        }
        return true;
    }

    private class BatchEngineZipEntryPair {
        private ZipEntry _configurationZipEntry;
        private ZipEntry _dataZipEntry;

        private BatchEngineZipEntryPair() {
        }

        protected boolean isValid() {
            return this._configurationZipEntry != null && this._dataZipEntry != null;
        }

        protected void setConfigurationZipEntry(ZipEntry zipEntry) {
            if (this._dataZipEntry != null && !this._parentDirectoryMatches(zipEntry, this._dataZipEntry)) {
                return;
            }
            this._configurationZipEntry = zipEntry;
        }

        protected void setDataZipEntry(ZipEntry zipEntry) {
            if (this._configurationZipEntry != null && !this._parentDirectoryMatches(zipEntry, this._configurationZipEntry)) {
                return;
            }
            this._dataZipEntry = zipEntry;
        }

        private boolean _parentDirectoryMatches(ZipEntry zipEntry1, ZipEntry zipEntry2) {
            String name1 = zipEntry1.getName();
            String name2 = zipEntry2.getName();
            if (!name1.contains("/") && !name2.contains("/")) {
                return true;
            }
            return name1.startsWith(name2.substring(0, name2.lastIndexOf("/"))) && name2.startsWith(name1.substring(0, name1.lastIndexOf("/")));
        }
    }

    private static final class BatchEngineImportConfiguration {
        @JsonProperty
        protected String callbackURL;
        @JsonProperty
        protected String className;
        @JsonProperty
        protected long companyId;
        @JsonProperty
        protected Map<String, String> fieldNameMappingMap;
        @JsonProperty
        protected Map<String, Serializable> parameters;
        @JsonProperty
        protected String taskItemDelegateName;
        @JsonProperty
        protected long userId;
        @JsonProperty
        protected String version;

        private BatchEngineImportConfiguration() {
        }
    }
}

