/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.reader;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class BatchEngineImportTaskItemReaderUtil {
    private static final ObjectMapper _objectMapper = new ObjectMapper();

    public static <T> T convertValue(Class<T> itemClass, Map<String, Object> fieldNameValueMap) throws ReflectiveOperationException {
        T item = itemClass.newInstance();
        for (Map.Entry<String, Object> entry : fieldNameValueMap.entrySet()) {
            String name = entry.getKey();
            Field field = null;
            for (Field declaredField : itemClass.getDeclaredFields()) {
                if (!name.equals(declaredField.getName()) && !Objects.equals("_" + name, declaredField.getName())) continue;
                field = declaredField;
                break;
            }
            if (field != null) {
                field.setAccessible(true);
                field.set(item, _objectMapper.convertValue(entry.getValue(), field.getType()));
                continue;
            }
            for (Field declaredField : itemClass.getDeclaredFields()) {
                JsonAnySetter[] jsonAnySetters = (JsonAnySetter[])declaredField.getAnnotationsByType(JsonAnySetter.class);
                if (jsonAnySetters.length <= 0) continue;
                field = declaredField;
                break;
            }
            if (field == null) {
                throw new NoSuchFieldException(entry.getKey());
            }
            field.setAccessible(true);
            Map map = (Map)field.get(item);
            map.put(entry.getKey(), entry.getValue());
        }
        return item;
    }

    public static Map<String, Object> mapFieldNames(Map<String, ? extends Serializable> fieldNameMappingMap, Map<String, Object> fieldNameValueMap) {
        if (fieldNameMappingMap == null || fieldNameMappingMap.isEmpty()) {
            return fieldNameValueMap;
        }
        HashMap<String, Object> targetFieldNameValueMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : fieldNameValueMap.entrySet()) {
            String targetFieldName = (String)((Object)fieldNameMappingMap.get(entry.getKey()));
            if (!Validator.isNotNull((String)targetFieldName)) continue;
            Object object = targetFieldNameValueMap.get(targetFieldName);
            if (object != null && object instanceof Map) {
                Map map = (Map)object;
                map.putAll((Map)entry.getValue());
                continue;
            }
            targetFieldNameValueMap.put(targetFieldName, entry.getValue());
        }
        return targetFieldNameValueMap;
    }
}

