/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.writer;

import com.liferay.batch.engine.BatchEngineTaskContentType;
import com.liferay.batch.engine.internal.writer.BatchEngineExportTaskItemWriter;
import com.liferay.batch.engine.internal.writer.CSVBatchEngineExportTaskItemWriterImpl;
import com.liferay.batch.engine.internal.writer.ItemClassIndexUtil;
import com.liferay.batch.engine.internal.writer.JSONBatchEngineExportTaskItemWriterImpl;
import com.liferay.batch.engine.internal.writer.JSONLBatchEngineExportTaskItemWriterImpl;
import com.liferay.batch.engine.internal.writer.XLSBatchEngineExportTaskItemWriterImpl;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;

public class BatchEngineExportTaskItemWriterFactory {
    private final String _csvFileColumnDelimiter;

    public BatchEngineExportTaskItemWriterFactory(String csvFileColumnDelimiter) {
        this._csvFileColumnDelimiter = csvFileColumnDelimiter;
    }

    public BatchEngineExportTaskItemWriter create(BatchEngineTaskContentType batchEngineTaskContentType, List<String> fieldNames, Class<?> itemClass, OutputStream outputStream, Map<String, Serializable> parameters) throws Exception {
        Map<String, Field> fieldMap = ItemClassIndexUtil.index(itemClass);
        if (batchEngineTaskContentType == BatchEngineTaskContentType.CSV) {
            return new CSVBatchEngineExportTaskItemWriterImpl(this._csvFileColumnDelimiter, fieldMap, fieldNames, outputStream, parameters);
        }
        if (batchEngineTaskContentType == BatchEngineTaskContentType.JSON) {
            return new JSONBatchEngineExportTaskItemWriterImpl(fieldMap.keySet(), fieldNames, outputStream);
        }
        if (batchEngineTaskContentType == BatchEngineTaskContentType.JSONL) {
            return new JSONLBatchEngineExportTaskItemWriterImpl(fieldMap.keySet(), fieldNames, outputStream);
        }
        if (batchEngineTaskContentType == BatchEngineTaskContentType.XLS || batchEngineTaskContentType == BatchEngineTaskContentType.XLSX) {
            return new XLSBatchEngineExportTaskItemWriterImpl(fieldMap, fieldNames, outputStream);
        }
        throw new IllegalArgumentException("Unknown batch engine task content type " + batchEngineTaskContentType);
    }
}

