/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.reader;

import com.liferay.batch.engine.internal.reader.BatchEngineImportTaskItemReader;
import com.liferay.batch.engine.internal.reader.FieldNameValueMapHandlerFactory;
import com.liferay.petra.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class CSVBatchEngineImportTaskItemReaderImpl
implements BatchEngineImportTaskItemReader {
    private static final String[] _ESCAPED_DELIMITERS = new String[]{"^", "]", "}", ")", "$", "!", "[", "{", "(", ".", "|", "+", "?", "*"};
    private final String _delimiter;
    private final String _delimiterRegex;
    private final String _enclosingCharacter;
    private final String[] _fieldNames;
    private final InputStream _inputStream;
    private final UnsyncBufferedReader _unsyncBufferedReader;

    public CSVBatchEngineImportTaskItemReaderImpl(String delimiter, InputStream inputStream, Map<String, Serializable> parameters) throws IOException {
        this._delimiter = (String)((Object)parameters.getOrDefault("delimiter", (Serializable)((Object)delimiter)));
        this._inputStream = inputStream;
        this._enclosingCharacter = this._getEnclosingCharacter(parameters);
        this._delimiterRegex = this._getDelimiterRegex(this._enclosingCharacter);
        this._unsyncBufferedReader = new UnsyncBufferedReader((Reader)new InputStreamReader(this._inputStream));
        this._fieldNames = this._getFieldNames(Boolean.valueOf((String)((Object)parameters.getOrDefault("containsHeaders", (Serializable)((Object)"true")))), this._delimiter, this._unsyncBufferedReader);
    }

    @Override
    public void close() throws IOException {
        this._unsyncBufferedReader.close();
    }

    @Override
    public Map<String, Object> read() throws Exception {
        String line = this._trimEnclosingCharacter(this._unsyncBufferedReader.readLine());
        if (Validator.isNull((String)line)) {
            return null;
        }
        HashMap<String, Object> fieldNameValueMap = new HashMap<String, Object>();
        String[] values = line.split(this._delimiterRegex);
        for (int i = 0; i < values.length; ++i) {
            String fieldName = this._fieldNames[i];
            if (fieldName == null) continue;
            FieldNameValueMapHandlerFactory.FieldNameValueMapHandler fieldNameValueMapHandler = FieldNameValueMapHandlerFactory.getFieldNameValueMapHandler(fieldName);
            fieldNameValueMapHandler.handle(fieldName, fieldNameValueMap, values[i]);
        }
        return fieldNameValueMap;
    }

    private String _getDelimiterRegex(String enclosingCharacter) {
        String escapedDelimiter = this._delimiter;
        for (String delimiter : _ESCAPED_DELIMITERS) {
            if (!delimiter.equals(escapedDelimiter)) continue;
            escapedDelimiter = "\\" + this._delimiter;
            break;
        }
        if (Validator.isNull((String)enclosingCharacter)) {
            return escapedDelimiter;
        }
        return StringBundler.concat((String[])new String[]{enclosingCharacter, escapedDelimiter, enclosingCharacter});
    }

    private String _getEnclosingCharacter(Map<String, Serializable> parameters) {
        String enclosingCharacter = parameters.getOrDefault("enclosingCharacter", null);
        if (Validator.isNull((String)enclosingCharacter)) {
            return null;
        }
        return enclosingCharacter;
    }

    private String[] _getFieldNames(boolean containsHeaders, String delimiter, UnsyncBufferedReader unsyncBufferedReader) throws IOException {
        if (containsHeaders) {
            return StringUtil.split((String)unsyncBufferedReader.readLine(), (String)delimiter);
        }
        String[] fieldNames = new String[100];
        for (int i = 0; i < fieldNames.length; ++i) {
            fieldNames[i] = String.valueOf(i);
        }
        return fieldNames;
    }

    private String _trimEnclosingCharacter(String line) {
        if (this._enclosingCharacter == null || Validator.isNull((String)line)) {
            return line;
        }
        if (line.startsWith(this._enclosingCharacter)) {
            line = line.substring(1);
        }
        if (line.endsWith(this._enclosingCharacter)) {
            line = line.substring(0, line.length() - 1);
        }
        return line;
    }
}

