/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal;

import com.liferay.batch.engine.BatchEngineExportTaskExecutor;
import com.liferay.batch.engine.BatchEngineTaskContentType;
import com.liferay.batch.engine.BatchEngineTaskExecuteStatus;
import com.liferay.batch.engine.configuration.BatchEngineTaskConfiguration;
import com.liferay.batch.engine.internal.BatchEngineTaskCallbackUtil;
import com.liferay.batch.engine.internal.BatchEngineTaskExecutorUtil;
import com.liferay.batch.engine.internal.BatchEngineTaskMethodRegistry;
import com.liferay.batch.engine.internal.item.BatchEngineTaskItemDelegateExecutor;
import com.liferay.batch.engine.internal.item.BatchEngineTaskItemDelegateExecutorFactory;
import com.liferay.batch.engine.internal.writer.BatchEngineExportTaskItemWriter;
import com.liferay.batch.engine.internal.writer.BatchEngineExportTaskItemWriterFactory;
import com.liferay.batch.engine.model.BatchEngineExportTask;
import com.liferay.batch.engine.pagination.Page;
import com.liferay.batch.engine.service.BatchEngineExportTaskLocalService;
import com.liferay.petra.function.UnsafeRunnable;
import com.liferay.petra.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.petra.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.dao.jdbc.OutputBlob;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.odata.sort.SortParserProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.batch.engine.configuration.BatchEngineTaskConfiguration"}, service={BatchEngineExportTaskExecutor.class})
public class BatchEngineExportTaskExecutorImpl
implements BatchEngineExportTaskExecutor {
    private static final Log _log = LogFactoryUtil.getLog(BatchEngineExportTaskExecutorImpl.class);
    private BatchEngineExportTaskItemWriterFactory _batchEngineExportTaskItemWriterFactory;
    @Reference
    private BatchEngineExportTaskLocalService _batchEngineExportTaskLocalService;
    private BatchEngineTaskItemDelegateExecutorFactory _batchEngineTaskItemDelegateExecutorFactory;
    @Reference
    private BatchEngineTaskMethodRegistry _batchEngineTaskMethodRegistry;
    private int _batchSize;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference(target="(result.class.name=com.liferay.portal.kernel.search.filter.Filter)")
    private ExpressionConvert<Filter> _expressionConvert;
    @Reference
    private FilterParserProvider _filterParserProvider;
    @Reference
    private SortParserProvider _sortParserProvider;
    @Reference
    private UserLocalService _userLocalService;

    public void execute(BatchEngineExportTask batchEngineExportTask) {
        try {
            batchEngineExportTask.setExecuteStatus(BatchEngineTaskExecuteStatus.STARTED.toString());
            batchEngineExportTask.setStartTime(new Date());
            this._batchEngineExportTaskLocalService.updateBatchEngineExportTask(batchEngineExportTask);
            BatchEngineTaskExecutorUtil.execute((UnsafeRunnable<Throwable>)((UnsafeRunnable)() -> this._exportItems(batchEngineExportTask)), this._userLocalService.getUser(batchEngineExportTask.getUserId()));
            this._updateBatchEngineExportTask(BatchEngineTaskExecuteStatus.COMPLETED, batchEngineExportTask, null);
        }
        catch (Throwable throwable) {
            _log.error((Object)("Unable to update batch engine export task " + batchEngineExportTask), throwable);
            try {
                BatchEngineExportTask currentBatchEngineExportTask = this._batchEngineExportTaskLocalService.getBatchEngineExportTask(batchEngineExportTask.getPrimaryKey());
                this._updateBatchEngineExportTask(BatchEngineTaskExecuteStatus.FAILED, currentBatchEngineExportTask, throwable.getMessage());
            }
            catch (PortalException portalException) {
                _log.error((Object)"Unable to update batch engine export task", (Throwable)portalException);
            }
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        BatchEngineTaskConfiguration batchEngineTaskConfiguration = (BatchEngineTaskConfiguration)ConfigurableUtil.createConfigurable(BatchEngineTaskConfiguration.class, properties);
        this._batchSize = batchEngineTaskConfiguration.exportBatchSize();
        this._batchEngineExportTaskItemWriterFactory = new BatchEngineExportTaskItemWriterFactory(GetterUtil.getString((String)batchEngineTaskConfiguration.csvFileColumnDelimiter(), (String)","));
        this._batchEngineTaskItemDelegateExecutorFactory = new BatchEngineTaskItemDelegateExecutorFactory(this._batchEngineTaskMethodRegistry, this._expressionConvert, this._filterParserProvider, this._sortParserProvider);
    }

    private void _exportItems(BatchEngineExportTask batchEngineExportTask) throws Exception {
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        try (BatchEngineTaskItemDelegateExecutor batchEngineTaskItemDelegateExecutor = this._batchEngineTaskItemDelegateExecutorFactory.create(batchEngineExportTask.getTaskItemDelegateName(), batchEngineExportTask.getClassName(), this._companyLocalService.getCompany(batchEngineExportTask.getCompanyId()), batchEngineExportTask.getParameters(), this._userLocalService.getUser(batchEngineExportTask.getUserId()));
             ZipOutputStream zipOutputStream = this._getZipOutputStream(batchEngineExportTask.getContentType(), unsyncByteArrayOutputStream);
             BatchEngineExportTaskItemWriter batchEngineExportTaskItemWriter = this._batchEngineExportTaskItemWriterFactory.create(BatchEngineTaskContentType.valueOf((String)batchEngineExportTask.getContentType()), batchEngineExportTask.getFieldNamesList(), this._batchEngineTaskMethodRegistry.getItemClass(batchEngineExportTask.getClassName()), zipOutputStream, batchEngineExportTask.getParameters());){
            Page<?> page = batchEngineTaskItemDelegateExecutor.getItems(1, this._batchSize);
            batchEngineExportTask.setTotalItemsCount(Math.toIntExact(page.getTotalCount()));
            Collection items = page.getItems();
            while (!items.isEmpty()) {
                batchEngineExportTaskItemWriter.write(items);
                batchEngineExportTask.setProcessedItemsCount(batchEngineExportTask.getProcessedItemsCount() + items.size());
                batchEngineExportTask = this._batchEngineExportTaskLocalService.updateBatchEngineExportTask(batchEngineExportTask);
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                if (!page.hasNext()) {
                    break;
                }
                page = batchEngineTaskItemDelegateExecutor.getItems((int)page.getPage() + 1, this._batchSize);
                items = page.getItems();
            }
        }
        byte[] content = unsyncByteArrayOutputStream.toByteArray();
        batchEngineExportTask.setContent((Blob)new OutputBlob((InputStream)new UnsyncByteArrayInputStream(content), (long)content.length));
        this._batchEngineExportTaskLocalService.updateBatchEngineExportTask(batchEngineExportTask);
    }

    private ZipOutputStream _getZipOutputStream(String contentType, UnsyncByteArrayOutputStream unsyncByteArrayOutputStream) throws IOException {
        ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)unsyncByteArrayOutputStream);
        ZipEntry zipEntry = new ZipEntry("export." + StringUtil.toLowerCase((String)contentType));
        zipOutputStream.putNextEntry(zipEntry);
        return zipOutputStream;
    }

    private void _updateBatchEngineExportTask(BatchEngineTaskExecuteStatus batchEngineTaskExecuteStatus, BatchEngineExportTask batchEngineExportTask, String errorMessage) {
        batchEngineExportTask.setEndTime(new Date());
        batchEngineExportTask.setErrorMessage(errorMessage);
        batchEngineExportTask.setExecuteStatus(batchEngineTaskExecuteStatus.toString());
        this._batchEngineExportTaskLocalService.updateBatchEngineExportTask(batchEngineExportTask);
        BatchEngineTaskCallbackUtil.sendCallback(batchEngineExportTask.getCallbackURL(), batchEngineExportTask.getExecuteStatus(), batchEngineExportTask.getBatchEngineExportTaskId());
    }
}

