/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.writer;

import com.liferay.batch.engine.internal.writer.BatchEngineExportTaskItemWriter;
import com.liferay.batch.engine.internal.writer.ColumnValuesExtractor;
import com.liferay.petra.io.unsync.UnsyncPrintWriter;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.util.ListUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class CSVBatchEngineExportTaskItemWriterImpl
implements BatchEngineExportTaskItemWriter {
    private final ColumnValuesExtractor _columnValuesExtractor;
    private final String _delimiter;
    private final UnsyncPrintWriter _unsyncPrintWriter;

    public CSVBatchEngineExportTaskItemWriterImpl(String delimiter, Map<String, Field> fieldMap, List<String> fieldNames, OutputStream outputStream, Map<String, Serializable> parameters) {
        if (fieldNames.isEmpty()) {
            throw new IllegalArgumentException("Field names are not set");
        }
        this._delimiter = delimiter;
        fieldNames = ListUtil.sort(fieldNames, (value1, value2) -> value1.compareToIgnoreCase((String)value2));
        this._columnValuesExtractor = new ColumnValuesExtractor(fieldMap, fieldNames);
        this._unsyncPrintWriter = new UnsyncPrintWriter(outputStream);
        if (Boolean.valueOf((String)((Object)parameters.getOrDefault("containsHeaders", (Serializable)((Object)"true")))).booleanValue()) {
            this._unsyncPrintWriter.println(StringUtil.merge((Collection)fieldNames, (String)delimiter));
        }
    }

    @Override
    public void close() throws IOException {
        this._unsyncPrintWriter.close();
    }

    @Override
    public void write(Collection<?> items) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        for (Object item : items) {
            this._write(dateFormat, this._columnValuesExtractor.extractValues(item));
        }
    }

    private void _write(DateFormat dateFormat, Collection<?> values) {
        this._unsyncPrintWriter.println(StringUtil.merge(values, value -> {
            if (value instanceof Date) {
                return dateFormat.format(value);
            }
            return String.valueOf(value);
        }, (String)this._delimiter));
    }
}

