/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.service.impl;

import com.liferay.batch.engine.model.BatchEngineExportTask;
import com.liferay.batch.engine.service.base.BatchEngineExportTaskServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component(property={"json.web.service.context.name=batchengine", "json.web.service.context.path=BatchEngineExportTask"}, service={AopService.class})
public class BatchEngineExportTaskServiceImpl
extends BatchEngineExportTaskServiceBaseImpl {
    public List<BatchEngineExportTask> getBatchEngineExportTasks(long companyId, int start, int end) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (companyId != permissionChecker.getCompanyId() && !permissionChecker.isOmniadmin()) {
            throw new PrincipalException();
        }
        return this.batchEngineExportTaskLocalService.getBatchEngineExportTasks(companyId, start, end);
    }

    public List<BatchEngineExportTask> getBatchEngineExportTasks(long companyId, int start, int end, OrderByComparator<BatchEngineExportTask> orderByComparator) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (companyId != permissionChecker.getCompanyId() && !permissionChecker.isOmniadmin()) {
            throw new PrincipalException();
        }
        return this.batchEngineExportTaskPersistence.findByCompanyId(companyId, start, end, orderByComparator);
    }

    public int getBatchEngineExportTasksCount(long companyId) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (companyId != permissionChecker.getCompanyId() && !permissionChecker.isOmniadmin()) {
            throw new PrincipalException();
        }
        return this.batchEngineExportTaskLocalService.getBatchEngineExportTasksCount(companyId);
    }
}

