/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.service.base;

import com.liferay.batch.engine.model.BatchEngineImportTask;
import com.liferay.batch.engine.model.BatchEngineImportTaskContentBlobModel;
import com.liferay.batch.engine.service.BatchEngineImportTaskLocalService;
import com.liferay.batch.engine.service.BatchEngineImportTaskLocalServiceUtil;
import com.liferay.batch.engine.service.persistence.BatchEngineImportTaskPersistence;
import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.io.AutoDeleteFileInputStream;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.dao.jdbc.ParamSetter;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.File;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.sql.Blob;
import java.util.List;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public abstract class BatchEngineImportTaskLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements AopService,
BatchEngineImportTaskLocalService,
IdentifiableOSGiService {
    protected BatchEngineImportTaskLocalService batchEngineImportTaskLocalService;
    @Reference
    protected BatchEngineImportTaskPersistence batchEngineImportTaskPersistence;
    @Reference
    protected CounterLocalService counterLocalService;
    @Reference
    protected File _file;
    private static final InputStream _EMPTY_INPUT_STREAM = new UnsyncByteArrayInputStream(new byte[0]);
    private boolean _useTempFile;

    @Indexable(type=IndexableType.REINDEX)
    public BatchEngineImportTask addBatchEngineImportTask(BatchEngineImportTask batchEngineImportTask) {
        batchEngineImportTask.setNew(true);
        return (BatchEngineImportTask)this.batchEngineImportTaskPersistence.update((BaseModel)batchEngineImportTask);
    }

    @Transactional(enabled=false)
    public BatchEngineImportTask createBatchEngineImportTask(long batchEngineImportTaskId) {
        return this.batchEngineImportTaskPersistence.create(batchEngineImportTaskId);
    }

    @Indexable(type=IndexableType.DELETE)
    public BatchEngineImportTask deleteBatchEngineImportTask(long batchEngineImportTaskId) throws PortalException {
        return this.batchEngineImportTaskPersistence.remove(batchEngineImportTaskId);
    }

    @Indexable(type=IndexableType.DELETE)
    public BatchEngineImportTask deleteBatchEngineImportTask(BatchEngineImportTask batchEngineImportTask) {
        return (BatchEngineImportTask)this.batchEngineImportTaskPersistence.remove((BaseModel)batchEngineImportTask);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.batchEngineImportTaskPersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(BatchEngineImportTask.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.batchEngineImportTaskPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.batchEngineImportTaskPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.batchEngineImportTaskPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.batchEngineImportTaskPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.batchEngineImportTaskPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public BatchEngineImportTask fetchBatchEngineImportTask(long batchEngineImportTaskId) {
        return this.batchEngineImportTaskPersistence.fetchByPrimaryKey(batchEngineImportTaskId);
    }

    public BatchEngineImportTask fetchBatchEngineImportTaskByUuidAndCompanyId(String uuid, long companyId) {
        return this.batchEngineImportTaskPersistence.fetchByUuid_C_First(uuid, companyId, null);
    }

    public BatchEngineImportTask getBatchEngineImportTask(long batchEngineImportTaskId) throws PortalException {
        return this.batchEngineImportTaskPersistence.findByPrimaryKey(batchEngineImportTaskId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.batchEngineImportTaskLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(BatchEngineImportTask.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("batchEngineImportTaskId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.batchEngineImportTaskLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(BatchEngineImportTask.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("batchEngineImportTaskId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.batchEngineImportTaskLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(BatchEngineImportTask.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("batchEngineImportTaskId");
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery(){

            public long performCount() throws PortalException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = this.getStagedModelType();
                long modelAdditionCount = super.performCount();
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
                long modelDeletionCount = ExportImportHelperUtil.getModelDeletionCount((PortletDataContext)portletDataContext, (StagedModelType)stagedModelType);
                manifestSummary.addModelDeletionCount(stagedModelType, modelDeletionCount);
                return modelAdditionCount;
            }
        };
        this.initActionableDynamicQuery((ActionableDynamicQuery)exportActionableDynamicQuery);
        exportActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                portletDataContext.addDateRangeCriteria(dynamicQuery, "modifiedDate");
            }
        });
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<BatchEngineImportTask>(){

            public void performAction(BatchEngineImportTask batchEngineImportTask) throws PortalException {
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)batchEngineImportTask);
            }
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(PortalUtil.getClassNameId((String)BatchEngineImportTask.class.getName())));
        return exportActionableDynamicQuery;
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.batchEngineImportTaskPersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        return this.batchEngineImportTaskLocalService.deleteBatchEngineImportTask((BatchEngineImportTask)persistedModel);
    }

    public BasePersistence<BatchEngineImportTask> getBasePersistence() {
        return this.batchEngineImportTaskPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.batchEngineImportTaskPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public BatchEngineImportTask getBatchEngineImportTaskByUuidAndCompanyId(String uuid, long companyId) throws PortalException {
        return this.batchEngineImportTaskPersistence.findByUuid_C_First(uuid, companyId, null);
    }

    public List<BatchEngineImportTask> getBatchEngineImportTasks(int start, int end) {
        return this.batchEngineImportTaskPersistence.findAll(start, end);
    }

    public int getBatchEngineImportTasksCount() {
        return this.batchEngineImportTaskPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public BatchEngineImportTask updateBatchEngineImportTask(BatchEngineImportTask batchEngineImportTask) {
        return (BatchEngineImportTask)this.batchEngineImportTaskPersistence.update((BaseModel)batchEngineImportTask);
    }

    public BatchEngineImportTaskContentBlobModel getContentBlobModel(Serializable primaryKey) {
        Session session = null;
        try {
            session = this.batchEngineImportTaskPersistence.openSession();
            BatchEngineImportTaskContentBlobModel batchEngineImportTaskContentBlobModel = (BatchEngineImportTaskContentBlobModel)session.get(BatchEngineImportTaskContentBlobModel.class, primaryKey);
            return batchEngineImportTaskContentBlobModel;
        }
        catch (Exception exception) {
            throw this.batchEngineImportTaskPersistence.processException(exception);
        }
        finally {
            this.batchEngineImportTaskPersistence.closeSession(session);
        }
    }

    @Transactional(readOnly=true)
    public InputStream openContentInputStream(long batchEngineImportTaskId) {
        try {
            BatchEngineImportTaskContentBlobModel BatchEngineImportTaskContentBlobModel2 = this.getContentBlobModel(Long.valueOf(batchEngineImportTaskId));
            Blob blob = BatchEngineImportTaskContentBlobModel2.getContentBlob();
            if (blob == null) {
                return _EMPTY_INPUT_STREAM;
            }
            InputStream inputStream = blob.getBinaryStream();
            if (this._useTempFile) {
                inputStream = new AutoDeleteFileInputStream(this._file.createTempFile(inputStream));
            }
            return inputStream;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    @Activate
    protected void activate() {
        DB db = DBManagerUtil.getDB();
        if (db.getDBType() != DBType.DB2 && db.getDBType() != DBType.MYSQL && db.getDBType() != DBType.MARIADB && db.getDBType() != DBType.SYBASE) {
            this._useTempFile = true;
        }
    }

    @Deactivate
    protected void deactivate() {
        this._setLocalServiceUtilService(null);
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{BatchEngineImportTaskLocalService.class, IdentifiableOSGiService.class, PersistedModelLocalService.class};
    }

    public void setAopProxy(Object aopProxy) {
        this.batchEngineImportTaskLocalService = (BatchEngineImportTaskLocalService)aopProxy;
        this._setLocalServiceUtilService(this.batchEngineImportTaskLocalService);
    }

    public String getOSGiServiceIdentifier() {
        return BatchEngineImportTaskLocalService.class.getName();
    }

    protected Class<?> getModelClass() {
        return BatchEngineImportTask.class;
    }

    protected String getModelClassName() {
        return BatchEngineImportTask.class.getName();
    }

    protected void runSQL(String sql) {
        try {
            DataSource dataSource = this.batchEngineImportTaskPersistence.getDataSource();
            DB db = DBManagerUtil.getDB();
            sql = db.buildSQL(sql);
            sql = PortalUtil.transformSQL((String)sql);
            SqlUpdate sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate((DataSource)dataSource, (String)sql, (ParamSetter[])new ParamSetter[0]);
            sqlUpdate.update(new Object[0]);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    private void _setLocalServiceUtilService(BatchEngineImportTaskLocalService batchEngineImportTaskLocalService) {
        try {
            Field field = BatchEngineImportTaskLocalServiceUtil.class.getDeclaredField("_service");
            field.setAccessible(true);
            field.set(null, batchEngineImportTaskLocalService);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }
}

