/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.strategy;

import com.liferay.batch.engine.internal.strategy.BaseBatchEngineImportStrategy;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.Collection;

public class OnErrorContinueBatchEngineImportStrategy
extends BaseBatchEngineImportStrategy {
    private static final Log _log = LogFactoryUtil.getLog(OnErrorContinueBatchEngineImportStrategy.class);
    private final long _batchEngineImportTaskId;
    private final long _companyId;
    private final int _processedItemsCount;
    private final long _userId;

    public OnErrorContinueBatchEngineImportStrategy(long batchEngineImportTaskId, long companyId, int processedItemsCount, long userId) {
        this._batchEngineImportTaskId = batchEngineImportTaskId;
        this._companyId = companyId;
        this._processedItemsCount = processedItemsCount;
        this._userId = userId;
    }

    public <T> void apply(Collection<T> collection, UnsafeConsumer<T, Exception> unsafeConsumer) throws Exception {
        int index = 0;
        for (T item : collection) {
            try {
                ++index;
                unsafeConsumer.accept(item);
            }
            catch (Exception exception) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)exception);
                }
                this.addBatchEngineImportTaskError(this._companyId, this._userId, this._batchEngineImportTaskId, item.toString(), this._processedItemsCount + index, exception.getMessage());
            }
        }
    }
}

