/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.task.progress;

import com.liferay.batch.engine.internal.task.progress.BatchEngineTaskProgress;
import com.liferay.batch.engine.internal.util.ZipInputStreamUtil;
import com.liferay.petra.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class JSONLBatchEngineTaskProgressImpl
implements BatchEngineTaskProgress {
    private static final Log _log = LogFactoryUtil.getLog(JSONLBatchEngineTaskProgressImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTotalItemsCount(InputStream inputStream) {
        int totalItemsCount = 0;
        UnsyncBufferedReader unsyncBufferedReader = null;
        try {
            unsyncBufferedReader = new UnsyncBufferedReader((Reader)new InputStreamReader(ZipInputStreamUtil.asZipInputStream(inputStream)));
            while (unsyncBufferedReader.readLine() != null) {
                ++totalItemsCount;
            }
        }
        catch (IOException ioException) {
            _log.error((Object)"Unable to get total items count", (Throwable)ioException);
            totalItemsCount = 0;
        }
        finally {
            try {
                if (unsyncBufferedReader != null) {
                    unsyncBufferedReader.close();
                }
            }
            catch (IOException ioException) {
                _log.error((Object)ioException, (Throwable)ioException);
            }
        }
        return totalItemsCount;
    }
}

