/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.bundle;

import com.liferay.batch.engine.internal.json.AdvancedJSONReader;
import com.liferay.batch.engine.unit.BatchEngineUnitConfiguration;
import com.liferay.batch.engine.unit.BatchEngineUnitMetaInfo;
import com.liferay.batch.engine.unit.BundleBatchEngineUnit;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.osgi.framework.Bundle;

public class AdvancedBundleBatchEngineUnitImpl
implements BundleBatchEngineUnit {
    private static final Log _log = LogFactoryUtil.getLog(AdvancedBundleBatchEngineUnitImpl.class);
    private BatchEngineUnitMetaInfo _batchEngineUnitMetaInfo;
    private final Bundle _bundle;
    private final URL _url;

    public AdvancedBundleBatchEngineUnitImpl(Bundle bundle, URL url) {
        this._bundle = bundle;
        this._url = url;
    }

    public BatchEngineUnitConfiguration getBatchEngineUnitConfiguration() throws IOException {
        try (InputStream inputStream = this._url.openStream();){
            long companyId;
            AdvancedJSONReader<BatchEngineUnitConfiguration> advancedJSONReader = new AdvancedJSONReader<BatchEngineUnitConfiguration>(inputStream);
            BatchEngineUnitConfiguration batchEngineUnitConfiguration = advancedJSONReader.getObject("configuration", BatchEngineUnitConfiguration.class);
            if (this._batchEngineUnitMetaInfo != null && (companyId = this._batchEngineUnitMetaInfo.getCompanyId()) > 0L) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)StringBundler.concat((Object[])new Object[]{"Overriding company ID ", batchEngineUnitConfiguration.getCompanyId(), " with company ID ", companyId}));
                }
                batchEngineUnitConfiguration.setCompanyId(companyId);
            }
            BatchEngineUnitConfiguration batchEngineUnitConfiguration2 = batchEngineUnitConfiguration;
            return batchEngineUnitConfiguration2;
        }
    }

    public BatchEngineUnitMetaInfo getBatchEngineUnitMetaInfo() {
        return this._batchEngineUnitMetaInfo;
    }

    public Bundle getBundle() {
        return this._bundle;
    }

    public InputStream getConfigurationInputStream() throws IOException {
        return this._url.openStream();
    }

    public String getDataFileName() {
        return this._url.getPath();
    }

    public InputStream getDataInputStream() throws IOException {
        try (InputStream inputStream = this._url.openStream();){
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            AdvancedJSONReader advancedJSONReader = new AdvancedJSONReader(inputStream);
            advancedJSONReader.transferJSONArray("items", byteArrayOutputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            return byteArrayInputStream;
        }
    }

    public String getFileName() {
        return this._bundle.toString();
    }

    public boolean isValid() {
        boolean bl;
        block9: {
            if (this._url == null) {
                return false;
            }
            InputStream inputStream = this._url.openStream();
            try {
                AdvancedJSONReader advancedJSONReader = new AdvancedJSONReader(inputStream);
                bl = advancedJSONReader.hasKey("items");
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioException) {
                    _log.error((Object)("Unable to get data in file " + this._url.getPath()), (Throwable)ioException);
                    return false;
                }
            }
            inputStream.close();
        }
        return bl;
    }

    public void setBatchEngineUnitMetaInfo(BatchEngineUnitMetaInfo batchEngineUnitMetaInfo) {
        this._batchEngineUnitMetaInfo = batchEngineUnitMetaInfo;
    }
}

