/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.service.base;

import com.liferay.batch.engine.model.BatchEngineExportTask;
import com.liferay.batch.engine.model.BatchEngineExportTaskContentBlobModel;
import com.liferay.batch.engine.service.BatchEngineExportTaskLocalService;
import com.liferay.batch.engine.service.persistence.BatchEngineExportTaskPersistence;
import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.io.AutoDeleteFileInputStream;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.File;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.Connection;
import java.util.List;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public abstract class BatchEngineExportTaskLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements AopService,
BatchEngineExportTaskLocalService,
IdentifiableOSGiService {
    protected BatchEngineExportTaskLocalService batchEngineExportTaskLocalService;
    @Reference
    protected BatchEngineExportTaskPersistence batchEngineExportTaskPersistence;
    @Reference
    protected CounterLocalService counterLocalService;
    private static final Log _log = LogFactoryUtil.getLog(BatchEngineExportTaskLocalServiceBaseImpl.class);
    @Reference
    protected File _file;
    private static final InputStream _EMPTY_INPUT_STREAM = new UnsyncByteArrayInputStream(new byte[0]);
    private boolean _useTempFile;

    @Indexable(type=IndexableType.REINDEX)
    public BatchEngineExportTask addBatchEngineExportTask(BatchEngineExportTask batchEngineExportTask) {
        batchEngineExportTask.setNew(true);
        return (BatchEngineExportTask)this.batchEngineExportTaskPersistence.update((BaseModel)batchEngineExportTask);
    }

    @Transactional(enabled=false)
    public BatchEngineExportTask createBatchEngineExportTask(long batchEngineExportTaskId) {
        return this.batchEngineExportTaskPersistence.create(batchEngineExportTaskId);
    }

    @Indexable(type=IndexableType.DELETE)
    public BatchEngineExportTask deleteBatchEngineExportTask(long batchEngineExportTaskId) throws PortalException {
        return this.batchEngineExportTaskPersistence.remove(batchEngineExportTaskId);
    }

    @Indexable(type=IndexableType.DELETE)
    public BatchEngineExportTask deleteBatchEngineExportTask(BatchEngineExportTask batchEngineExportTask) {
        return (BatchEngineExportTask)this.batchEngineExportTaskPersistence.remove((BaseModel)batchEngineExportTask);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.batchEngineExportTaskPersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(BatchEngineExportTask.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.batchEngineExportTaskPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.batchEngineExportTaskPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.batchEngineExportTaskPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.batchEngineExportTaskPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.batchEngineExportTaskPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public BatchEngineExportTask fetchBatchEngineExportTask(long batchEngineExportTaskId) {
        return this.batchEngineExportTaskPersistence.fetchByPrimaryKey(batchEngineExportTaskId);
    }

    public BatchEngineExportTask fetchBatchEngineExportTaskByUuidAndCompanyId(String uuid, long companyId) {
        return this.batchEngineExportTaskPersistence.fetchByUuid_C_First(uuid, companyId, null);
    }

    public BatchEngineExportTask fetchBatchEngineExportTaskByExternalReferenceCode(String externalReferenceCode, long companyId) {
        return this.batchEngineExportTaskPersistence.fetchByERC_C(externalReferenceCode, companyId);
    }

    public BatchEngineExportTask getBatchEngineExportTaskByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        return this.batchEngineExportTaskPersistence.findByERC_C(externalReferenceCode, companyId);
    }

    public BatchEngineExportTask getBatchEngineExportTask(long batchEngineExportTaskId) throws PortalException {
        return this.batchEngineExportTaskPersistence.findByPrimaryKey(batchEngineExportTaskId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.batchEngineExportTaskLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(BatchEngineExportTask.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("batchEngineExportTaskId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.batchEngineExportTaskLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(BatchEngineExportTask.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("batchEngineExportTaskId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.batchEngineExportTaskLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(BatchEngineExportTask.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("batchEngineExportTaskId");
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery(){

            public long performCount() throws PortalException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = this.getStagedModelType();
                long modelAdditionCount = super.performCount();
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
                long modelDeletionCount = ExportImportHelperUtil.getModelDeletionCount((PortletDataContext)portletDataContext, (StagedModelType)stagedModelType);
                manifestSummary.addModelDeletionCount(stagedModelType, modelDeletionCount);
                return modelAdditionCount;
            }
        };
        this.initActionableDynamicQuery((ActionableDynamicQuery)exportActionableDynamicQuery);
        exportActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                portletDataContext.addDateRangeCriteria(dynamicQuery, "modifiedDate");
            }
        });
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<BatchEngineExportTask>(){

            public void performAction(BatchEngineExportTask batchEngineExportTask) throws PortalException {
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)batchEngineExportTask);
            }
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(PortalUtil.getClassNameId((String)BatchEngineExportTask.class.getName())));
        return exportActionableDynamicQuery;
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.batchEngineExportTaskPersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Implement BatchEngineExportTaskLocalServiceImpl#deleteBatchEngineExportTask(BatchEngineExportTask) to avoid orphaned data");
        }
        return this.batchEngineExportTaskLocalService.deleteBatchEngineExportTask((BatchEngineExportTask)persistedModel);
    }

    public BasePersistence<BatchEngineExportTask> getBasePersistence() {
        return this.batchEngineExportTaskPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.batchEngineExportTaskPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public BatchEngineExportTask getBatchEngineExportTaskByUuidAndCompanyId(String uuid, long companyId) throws PortalException {
        return this.batchEngineExportTaskPersistence.findByUuid_C_First(uuid, companyId, null);
    }

    public List<BatchEngineExportTask> getBatchEngineExportTasks(int start, int end) {
        return this.batchEngineExportTaskPersistence.findAll(start, end);
    }

    public int getBatchEngineExportTasksCount() {
        return this.batchEngineExportTaskPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public BatchEngineExportTask updateBatchEngineExportTask(BatchEngineExportTask batchEngineExportTask) {
        return (BatchEngineExportTask)this.batchEngineExportTaskPersistence.update((BaseModel)batchEngineExportTask);
    }

    public BatchEngineExportTaskContentBlobModel getContentBlobModel(Serializable primaryKey) {
        Session session = null;
        try {
            session = this.batchEngineExportTaskPersistence.openSession();
            BatchEngineExportTaskContentBlobModel batchEngineExportTaskContentBlobModel = (BatchEngineExportTaskContentBlobModel)session.get(BatchEngineExportTaskContentBlobModel.class, primaryKey);
            return batchEngineExportTaskContentBlobModel;
        }
        catch (Exception exception) {
            throw this.batchEngineExportTaskPersistence.processException(exception);
        }
        finally {
            this.batchEngineExportTaskPersistence.closeSession(session);
        }
    }

    @Transactional(readOnly=true)
    public InputStream openContentInputStream(long batchEngineExportTaskId) {
        try {
            BatchEngineExportTaskContentBlobModel BatchEngineExportTaskContentBlobModel2 = this.getContentBlobModel(Long.valueOf(batchEngineExportTaskId));
            Blob blob = BatchEngineExportTaskContentBlobModel2.getContentBlob();
            if (blob == null) {
                return _EMPTY_INPUT_STREAM;
            }
            InputStream inputStream = blob.getBinaryStream();
            if (this._useTempFile) {
                inputStream = new AutoDeleteFileInputStream(this._file.createTempFile(inputStream));
            }
            return inputStream;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    @Activate
    protected void activate() {
        DB db = DBManagerUtil.getDB();
        if (db.getDBType() != DBType.DB2 && db.getDBType() != DBType.MYSQL && db.getDBType() != DBType.MARIADB) {
            this._useTempFile = true;
        }
    }

    @Deactivate
    protected void deactivate() {
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{BatchEngineExportTaskLocalService.class, IdentifiableOSGiService.class, PersistedModelLocalService.class};
    }

    public void setAopProxy(Object aopProxy) {
        this.batchEngineExportTaskLocalService = (BatchEngineExportTaskLocalService)aopProxy;
    }

    public String getOSGiServiceIdentifier() {
        return BatchEngineExportTaskLocalService.class.getName();
    }

    protected Class<?> getModelClass() {
        return BatchEngineExportTask.class;
    }

    protected String getModelClassName() {
        return BatchEngineExportTask.class.getName();
    }

    protected void runSQL(String sql) {
        DataSource dataSource = this.batchEngineExportTaskPersistence.getDataSource();
        DB db = DBManagerUtil.getDB();
        Connection currentConnection = CurrentConnectionUtil.getConnection((DataSource)dataSource);
        try {
            if (currentConnection != null) {
                db.runSQL(currentConnection, new String[]{sql});
                return;
            }
            try (Connection connection = dataSource.getConnection();){
                db.runSQL(connection, new String[]{sql});
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

