/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.action;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.liferay.batch.engine.BatchEngineTaskItemDelegate;
import com.liferay.batch.engine.action.ImportTaskPreAction;
import com.liferay.batch.engine.context.ImportTaskContext;
import com.liferay.batch.engine.model.BatchEngineImportTask;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.jackson.databind.ser.VulcanPropertyFilter;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ImportTaskPreAction.class})
public class ItemImportTaskPreAction
implements ImportTaskPreAction {
    private static final Log _log = LogFactoryUtil.getLog(ItemImportTaskPreAction.class);
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private UserLocalService _userLocalService;

    public void run(BatchEngineImportTask batchEngineImportTask, BatchEngineTaskItemDelegate<?> batchEngineTaskItemDelegate, ImportTaskContext importTaskContext, Object item) throws Exception {
        if (!StringUtil.equals((String)batchEngineImportTask.getParameterValue("importCreatorStrategy"), (String)"KEEP_CREATOR")) {
            return;
        }
        JSONObject jsonObject = this._toJSONObject(item);
        if (jsonObject == null) {
            return;
        }
        User user = this._getCreatorUser(jsonObject);
        if (user == null) {
            return;
        }
        long userId = GetterUtil.getLong((String)PrincipalThreadLocal.getName());
        if (userId == user.getUserId()) {
            return;
        }
        PrincipalThreadLocal.setName((long)user.getUserId());
        batchEngineTaskItemDelegate.setContextUser(user);
        importTaskContext.setOriginalUser(this._userLocalService.getUser(userId));
    }

    private User _getCreatorUser(JSONObject jsonObject) {
        long userId;
        JSONObject creatorJSONObject = jsonObject.getJSONObject("creator");
        if (creatorJSONObject == null) {
            return null;
        }
        User user = null;
        String externalReferenceCode = creatorJSONObject.getString("externalReferenceCode");
        if (!Validator.isBlank((String)externalReferenceCode)) {
            user = this._userLocalService.fetchUserByExternalReferenceCode(externalReferenceCode, CompanyThreadLocal.getCompanyId().longValue());
        }
        if (user == null && (userId = creatorJSONObject.getLong("id")) > 0L) {
            user = this._userLocalService.fetchUser(userId);
        }
        return user;
    }

    private String _toJSON(Object item) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectWriter objectWriter = objectMapper.writer((FilterProvider)new SimpleFilterProvider().addFilter("Liferay.Vulcan", (SimpleBeanPropertyFilter)VulcanPropertyFilter.of(Set.of("creator", "creator.externalReferenceCode", "creator.id"), null)));
        return objectWriter.writeValueAsString(item);
    }

    private JSONObject _toJSONObject(Object item) {
        try {
            String json = this._toJSON(item);
            if (Validator.isNull((String)json)) {
                return null;
            }
            return this._jsonFactory.createJSONObject(json);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return null;
        }
    }
}

