/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.strategy;

import com.liferay.batch.engine.BatchEngineTaskItemDelegate;
import com.liferay.batch.engine.action.ImportTaskPostAction;
import com.liferay.batch.engine.action.ImportTaskPreAction;
import com.liferay.batch.engine.context.ImportTaskContext;
import com.liferay.batch.engine.internal.util.ErrorMessageUtil;
import com.liferay.batch.engine.model.BatchEngineImportTask;
import com.liferay.batch.engine.service.BatchEngineImportTaskErrorLocalServiceUtil;
import com.liferay.batch.engine.strategy.BatchEngineImportStrategy;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import java.util.Collection;
import java.util.List;

public abstract class BaseBatchEngineImportStrategy
implements BatchEngineImportStrategy {
    protected final BatchEngineImportTask batchEngineImportTask;
    protected final List<ImportTaskPostAction> importTaskPostActions;
    protected final List<ImportTaskPreAction> importTaskPreActions;
    private static final TransactionConfig _transactionConfig = TransactionConfig.Factory.create((Propagation)Propagation.REQUIRES_NEW, (Class[])new Class[]{Exception.class}, (Class[])new Class[0]);

    public BaseBatchEngineImportStrategy(BatchEngineImportTask batchEngineImportTask, List<ImportTaskPostAction> importTaskPostActions, List<ImportTaskPreAction> importTaskPreActions) {
        this.batchEngineImportTask = batchEngineImportTask;
        this.importTaskPostActions = importTaskPostActions;
        this.importTaskPreActions = importTaskPreActions;
    }

    public <T> void apply(BatchEngineTaskItemDelegate<T> batchEngineTaskItemDelegate, Collection<T> collection, UnsafeFunction<T, T, Exception> unsafeFunction) throws Exception {
        for (T item : collection) {
            this.importItem(item, element -> {
                ImportTaskContext importTaskContext = new ImportTaskContext();
                for (ImportTaskPreAction importTaskPreAction : this.importTaskPreActions) {
                    importTaskPreAction.run(this.batchEngineImportTask, batchEngineTaskItemDelegate, importTaskContext, element);
                }
                Object persistedItem = unsafeFunction.apply(element);
                if (persistedItem == null) {
                    return null;
                }
                for (ImportTaskPostAction importTaskPostAction : this.importTaskPostActions) {
                    importTaskPostAction.run(this.batchEngineImportTask, batchEngineTaskItemDelegate, importTaskContext, element, persistedItem);
                }
                return persistedItem;
            });
        }
    }

    protected void addBatchEngineImportTaskError(long companyId, long userId, long batchEngineImportTaskId, String item, int itemIndex, Exception exception) {
        try {
            TransactionInvokerUtil.invoke((TransactionConfig)_transactionConfig, () -> {
                BatchEngineImportTaskErrorLocalServiceUtil.addBatchEngineImportTaskError((long)companyId, (long)userId, (long)batchEngineImportTaskId, (String)item, (int)itemIndex, (String)ErrorMessageUtil.getErrorMessage(exception, userId));
                return null;
            });
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    protected abstract <T> T importItem(T var1, UnsafeFunction<T, T, Exception> var2) throws Exception;
}

