/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.exportimport.data.handler;

import com.liferay.batch.engine.BatchEngineExportTaskExecutor;
import com.liferay.batch.engine.BatchEngineImportTaskExecutor;
import com.liferay.batch.engine.BatchEngineTaskExecuteStatus;
import com.liferay.batch.engine.BatchEngineTaskOperation;
import com.liferay.batch.engine.constants.CreateStrategy;
import com.liferay.batch.engine.internal.exportimport.data.handler.BatchEnginePortletDataHandlerUtil;
import com.liferay.batch.engine.model.BatchEngineImportTask;
import com.liferay.batch.engine.service.BatchEngineExportTaskService;
import com.liferay.batch.engine.service.BatchEngineImportTaskService;
import com.liferay.exportimport.kernel.lar.BasePortletDataHandler;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerControl;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.io.StreamUtil;
import com.liferay.petra.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.MapUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.portlet.PortletPreferences;

public class BatchEnginePortletDataHandler
extends BasePortletDataHandler {
    public static final String SCHEMA_VERSION = "4.0.0";
    protected static final TransactionConfig transactionConfig = TransactionConfig.Factory.create((Propagation)Propagation.REQUIRES_NEW, (Class[])new Class[]{Exception.class}, (Class[])new Class[0]);
    private final BatchEngineExportTaskExecutor _batchEngineExportTaskExecutor;
    private final BatchEngineExportTaskService _batchEngineExportTaskService;
    private final BatchEngineImportTaskExecutor _batchEngineImportTaskExecutor;
    private final BatchEngineImportTaskService _batchEngineImportTaskService;
    private final String _className;
    private final String _fileName;
    private final String _itemClassName;
    private final String _taskItemDelegateName;

    public BatchEnginePortletDataHandler(BatchEngineExportTaskExecutor batchEngineExportTaskExecutor, BatchEngineExportTaskService batchEngineExportTaskService, BatchEngineImportTaskExecutor batchEngineImportTaskExecutor, BatchEngineImportTaskService batchEngineImportTaskService, String className, String itemClassName, String taskItemDelegateName) {
        this._batchEngineExportTaskExecutor = batchEngineExportTaskExecutor;
        this._batchEngineExportTaskService = batchEngineExportTaskService;
        this._batchEngineImportTaskExecutor = batchEngineImportTaskExecutor;
        this._batchEngineImportTaskService = batchEngineImportTaskService;
        this._className = className;
        this._itemClassName = itemClassName;
        this._taskItemDelegateName = taskItemDelegateName;
        this._fileName = taskItemDelegateName + ".json";
        this.setEmptyControlsAllowed(true);
    }

    public String[] getClassNames() {
        return new String[]{this._className};
    }

    public StagedModelType[] getDeletionSystemEventStagedModelTypes() {
        return new StagedModelType[]{new StagedModelType(this._itemClassName)};
    }

    public String getName() {
        return this._className + "#" + this._taskItemDelegateName;
    }

    public String getSchemaVersion() {
        return SCHEMA_VERSION;
    }

    public boolean isCompany() {
        return true;
    }

    public boolean isModelCountSupported() {
        return false;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        BatchEngineExportTaskExecutor.Result result = this._batchEngineExportTaskExecutor.execute(this._batchEngineExportTaskService.addBatchEngineExportTask(null, portletDataContext.getCompanyId(), this._getUserId(), null, this._className, "JSON", BatchEngineTaskExecuteStatus.INITIAL.name(), Collections.emptyList(), BatchEnginePortletDataHandlerUtil.buildParameters(portletDataContext), this._taskItemDelegateName), new BatchEngineExportTaskExecutor.Settings(){

            public boolean isCompressContent() {
                return false;
            }

            public boolean isPersistContent() {
                return false;
            }
        });
        portletDataContext.addZipEntry(this._fileName, result.getInputStream());
        portletDataContext.setValidateExistingDataHandler(true);
        return this.getExportDataRootElementString(this.addExportDataRootElement(portletDataContext));
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        InputStream inputStream = portletDataContext.getZipEntryAsInputStream(this._fileName);
        if (inputStream == null) {
            return portletPreferences;
        }
        BatchEngineImportTask batchEngineImportTask = this._batchEngineImportTaskService.addBatchEngineImportTask(null, portletDataContext.getCompanyId(), this._getUserId(), 100L, null, this._className, this._getBytes(this._fileName, inputStream), "JSON", BatchEngineTaskExecuteStatus.INITIAL.name(), Collections.emptyMap(), 1, BatchEngineTaskOperation.CREATE.name(), (Map)HashMapBuilder.put((Object)"batchRestrictFields", () -> {
            if (!MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"PERMISSIONS")) {
                return "permissions";
            }
            return null;
        }).put((Object)"createStrategy", (Object)CreateStrategy.UPSERT.getDBOperation()).put((Object)"importCreatorStrategy", () -> {
            if (!"CURRENT_USER_ID".equals(MapUtil.getString((Map)portletDataContext.getParameterMap(), (Object)"USER_ID_STRATEGY"))) {
                return null;
            }
            return "KEEP_CREATOR";
        }).build(), this._taskItemDelegateName);
        try {
            BatchEngineImportTask finalBatchEngineImportTask = batchEngineImportTask;
            TransactionInvokerUtil.invoke((TransactionConfig)transactionConfig, () -> {
                this._batchEngineImportTaskExecutor.execute(finalBatchEngineImportTask);
                return null;
            });
        }
        catch (Throwable throwable) {
            throw new PortletDataException(throwable);
        }
        batchEngineImportTask = this._batchEngineImportTaskService.getBatchEngineImportTask(batchEngineImportTask.getBatchEngineImportTaskId());
        BatchEngineTaskExecuteStatus batchEngineTaskExecuteStatus = BatchEngineTaskExecuteStatus.valueOf((String)batchEngineImportTask.getExecuteStatus());
        if (batchEngineTaskExecuteStatus == BatchEngineTaskExecuteStatus.FAILED) {
            throw new PortletDataException("Unable to import batch data: " + batchEngineImportTask.getErrorMessage());
        }
        return portletPreferences;
    }

    protected long getExportModelCount(ManifestSummary manifestSummary, PortletDataHandlerControl[] portletDataHandlerControls) {
        return 0L;
    }

    private byte[] _getBytes(String fileName, InputStream inputStream) throws Exception {
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        try (ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)unsyncByteArrayOutputStream);){
            ZipEntry zipEntry = new ZipEntry(fileName);
            zipOutputStream.putNextEntry(zipEntry);
            StreamUtil.transfer((InputStream)inputStream, (OutputStream)zipOutputStream, (boolean)false);
        }
        return unsyncByteArrayOutputStream.toByteArray();
    }

    private long _getUserId() {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        return permissionChecker.getUserId();
    }
}

