/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.task.progress;

import com.liferay.batch.engine.internal.task.progress.BatchEngineTaskProgress;
import com.liferay.batch.engine.internal.util.ZipInputStreamUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class XLSBatchEngineTaskProgressImpl
implements BatchEngineTaskProgress {
    private static final Log _log = LogFactoryUtil.getLog(XLSBatchEngineTaskProgressImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTotalItemsCount(InputStream inputStream) {
        int totalItemsCount = 0;
        try {
            XSSFWorkbook workbook = new XSSFWorkbook(ZipInputStreamUtil.asZipInputStream(inputStream));
            Sheet sheet = workbook.getSheetAt(0);
            Iterator iterator = sheet.rowIterator();
            if (iterator.hasNext()) {
                iterator.next();
            }
            while (iterator.hasNext()) {
                iterator.next();
                ++totalItemsCount;
            }
        }
        catch (IOException ioException) {
            _log.error((Object)"Unable to get total items count", (Throwable)ioException);
            totalItemsCount = 0;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException ioException) {
                _log.error((Throwable)ioException);
            }
        }
        return totalItemsCount;
    }
}

