/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.exportimport.data.handler;

import com.liferay.batch.engine.BatchEngineExportTaskExecutor;
import com.liferay.batch.engine.BatchEngineImportTaskExecutor;
import com.liferay.batch.engine.BatchEngineTaskExecuteStatus;
import com.liferay.batch.engine.BatchEngineTaskOperation;
import com.liferay.batch.engine.constants.CreateStrategy;
import com.liferay.batch.engine.model.BatchEngineExportTask;
import com.liferay.batch.engine.model.BatchEngineImportTask;
import com.liferay.batch.engine.service.BatchEngineExportTaskService;
import com.liferay.batch.engine.service.BatchEngineImportTaskService;
import com.liferay.exportimport.kernel.lar.BasePortletDataHandler;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerControl;
import com.liferay.petra.io.StreamUtil;
import com.liferay.petra.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.MapUtil;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.Format;
import java.util.Collections;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.portlet.PortletPreferences;

public class BatchEnginePortletDataHandler
extends BasePortletDataHandler {
    public static final String SCHEMA_VERSION = "4.0.0";
    private static final Format _format = FastDateFormatFactoryUtil.getSimpleDateFormat((String)"yyyy-MM-dd'T'HH:mm:ss'Z'");
    private final BatchEngineExportTaskExecutor _batchEngineExportTaskExecutor;
    private final BatchEngineExportTaskService _batchEngineExportTaskService;
    private final BatchEngineImportTaskExecutor _batchEngineImportTaskExecutor;
    private final BatchEngineImportTaskService _batchEngineImportTaskService;
    private final String _className;
    private final String _fileName;
    private final String _taskItemDelegateName;

    public BatchEnginePortletDataHandler(BatchEngineExportTaskExecutor batchEngineExportTaskExecutor, BatchEngineExportTaskService batchEngineExportTaskService, BatchEngineImportTaskExecutor batchEngineImportTaskExecutor, BatchEngineImportTaskService batchEngineImportTaskService, String className, String taskItemDelegateName) {
        this._batchEngineExportTaskExecutor = batchEngineExportTaskExecutor;
        this._batchEngineExportTaskService = batchEngineExportTaskService;
        this._batchEngineImportTaskExecutor = batchEngineImportTaskExecutor;
        this._batchEngineImportTaskService = batchEngineImportTaskService;
        this._className = className;
        this._taskItemDelegateName = taskItemDelegateName;
        this._fileName = taskItemDelegateName + ".json";
        this.setExportControls(new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(taskItemDelegateName, taskItemDelegateName, true, true, null, className)});
    }

    public String[] getClassNames() {
        return new String[]{this._className};
    }

    public String getName() {
        return this._className + "#" + this._taskItemDelegateName;
    }

    public String getSchemaVersion() {
        return SCHEMA_VERSION;
    }

    public boolean isCompany() {
        return true;
    }

    protected Map<String, Serializable> buildParameters(PortletDataContext portletDataContext) {
        return HashMapBuilder.put((Object)"batchNestedFields", () -> {
            if (MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"PERMISSIONS")) {
                return "permissions";
            }
            return null;
        }).put((Object)"filter", () -> {
            if (portletDataContext.getEndDate() == null && portletDataContext.getStartDate() == null) {
                return null;
            }
            StringBundler sb = new StringBundler(5);
            if (portletDataContext.getEndDate() != null) {
                sb.append("dateModified le ");
                sb.append(_format.format(portletDataContext.getEndDate()));
            }
            if (portletDataContext.getStartDate() != null) {
                if (sb.length() > 0) {
                    sb.append(" and ");
                }
                sb.append("dateModified ge ");
                sb.append(_format.format(portletDataContext.getStartDate()));
            }
            return sb.toString();
        }).build();
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        BatchEngineExportTask batchEngineExportTask = this._batchEngineExportTaskService.addBatchEngineExportTask(null, portletDataContext.getCompanyId(), this._getUserId(), null, this._className, "JSON", BatchEngineTaskExecuteStatus.INITIAL.name(), Collections.emptyList(), this.buildParameters(portletDataContext), this._taskItemDelegateName);
        this._batchEngineExportTaskExecutor.execute(batchEngineExportTask);
        portletDataContext.addZipEntry(this._fileName, this._getBytes(batchEngineExportTask));
        return this.getExportDataRootElementString(this.addExportDataRootElement(portletDataContext));
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        InputStream inputStream = portletDataContext.getZipEntryAsInputStream(this._fileName);
        if (inputStream == null) {
            return portletPreferences;
        }
        BatchEngineImportTask batchEngineImportTask = this._batchEngineImportTaskService.addBatchEngineImportTask(null, portletDataContext.getCompanyId(), this._getUserId(), 100L, null, this._className, this._getBytes(this._fileName, inputStream), "JSON", BatchEngineTaskExecuteStatus.INITIAL.name(), Collections.emptyMap(), 2, BatchEngineTaskOperation.CREATE.name(), (Map)HashMapBuilder.put((Object)"batchRestrictFields", () -> {
            if (!MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"PERMISSIONS")) {
                return "permissions";
            }
            return null;
        }).put((Object)"createStrategy", (Object)CreateStrategy.UPSERT.getDBOperation()).build(), this._taskItemDelegateName);
        this._batchEngineImportTaskExecutor.execute(batchEngineImportTask);
        batchEngineImportTask = this._batchEngineImportTaskService.getBatchEngineImportTask(batchEngineImportTask.getBatchEngineImportTaskId());
        BatchEngineTaskExecuteStatus batchEngineTaskExecuteStatus = BatchEngineTaskExecuteStatus.valueOf((String)batchEngineImportTask.getExecuteStatus());
        if (batchEngineTaskExecuteStatus == BatchEngineTaskExecuteStatus.FAILED) {
            throw new PortletDataException("Unable to import batch data: " + batchEngineImportTask.getErrorMessage());
        }
        return portletPreferences;
    }

    protected long getExportModelCount(ManifestSummary manifestSummary, PortletDataHandlerControl[] portletDataHandlerControls) {
        return 1L;
    }

    private byte[] _getBytes(BatchEngineExportTask batchEngineExportTask) throws Exception {
        try (InputStream inputStream = this._batchEngineExportTaskService.openContentInputStream(batchEngineExportTask.getBatchEngineExportTaskId());){
            File batchZipFile = FileUtil.createTempFile((InputStream)inputStream);
            File tempFolder = FileUtil.createTempFolder();
            FileUtil.unzip((File)batchZipFile, (File)tempFolder);
            byte[] byArray = FileUtil.getBytes((File)new File(tempFolder, "export.json"));
            return byArray;
        }
    }

    private byte[] _getBytes(String fileName, InputStream inputStream) throws Exception {
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        try (ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)unsyncByteArrayOutputStream);){
            ZipEntry zipEntry = new ZipEntry(fileName);
            zipOutputStream.putNextEntry(zipEntry);
            StreamUtil.transfer((InputStream)inputStream, (OutputStream)zipOutputStream, (boolean)false);
        }
        return unsyncByteArrayOutputStream.toByteArray();
    }

    private long _getUserId() {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        return permissionChecker.getUserId();
    }
}

