/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.reader;

import com.liferay.batch.engine.internal.reader.BatchEngineImportTaskItemReader;
import com.liferay.batch.engine.internal.reader.FieldNameValueMapHandlerFactory;
import com.liferay.petra.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.util.CSVUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class CSVBatchEngineImportTaskItemReaderImpl
implements BatchEngineImportTaskItemReader {
    private final CSVParser _csvParser;
    private final String _delimiter;
    private final String _enclosingCharacter;
    private final String[] _fieldNames;
    private final Iterator<CSVRecord> _iterator;

    public CSVBatchEngineImportTaskItemReaderImpl(String delimiter, InputStream inputStream, Map<String, Serializable> parameters) throws IOException {
        this._delimiter = (String)((Object)parameters.getOrDefault("delimiter", (Serializable)((Object)delimiter)));
        this._enclosingCharacter = (String)((Object)parameters.getOrDefault("enclosingCharacter", (Serializable)((Object)"\"")));
        this._csvParser = CSVParser.parse((Reader)new UnsyncBufferedReader((Reader)new InputStreamReader(inputStream)), (CSVFormat)CSVFormat.Builder.create().setDelimiter(this._delimiter).setIgnoreEmptyLines(true).setQuote(this._enclosingCharacter.charAt(0)).build());
        this._iterator = this._csvParser.iterator();
        this._fieldNames = this._getFieldNames(Boolean.valueOf((String)((Object)parameters.getOrDefault("containsHeaders", (Serializable)((Object)"true")))), this._iterator);
    }

    @Override
    public void close() throws IOException {
        this._csvParser.close();
    }

    @Override
    public Map<String, Object> read() throws Exception {
        if (!this._iterator.hasNext()) {
            return null;
        }
        LinkedHashMap<String, Object> fieldNameValueMap = new LinkedHashMap<String, Object>();
        CSVRecord csvRecord = this._iterator.next();
        List values = csvRecord.toList();
        for (int i = 0; i < values.size(); ++i) {
            String fieldName = this._fieldNames[i];
            if (fieldName == null) continue;
            FieldNameValueMapHandlerFactory.FieldNameValueMapHandler fieldNameValueMapHandler = FieldNameValueMapHandlerFactory.getFieldNameValueMapHandler(fieldName);
            fieldNameValueMapHandler.handle(fieldName, fieldNameValueMap, CSVUtil.decode((String)this._enclosingCharacter, (String)this._delimiter, (String)((String)values.get(i))));
        }
        return fieldNameValueMap;
    }

    private String[] _getFieldNames(boolean containsHeaders, Iterator<CSVRecord> csvRecordIterator) {
        if (containsHeaders) {
            CSVRecord csvRecord = csvRecordIterator.next();
            List fieldNamesList = csvRecord.toList();
            return fieldNamesList.toArray(new String[0]);
        }
        String[] fieldNames = new String[100];
        for (int i = 0; i < fieldNames.length; ++i) {
            fieldNames[i] = String.valueOf(i);
        }
        return fieldNames;
    }
}

