/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.reader;

import java.util.HashMap;
import java.util.Map;

public class FieldNameValueMapHandlerFactory {
    private static final FieldNameValueMapHandler _baseFieldNameValueMapHandler = new BaseFieldNameValueMapHandler();
    private static final FieldNameValueMapHandler _i18nFieldNameValueMapHandler = new I18nFieldNameValueMapHandler();

    public static FieldNameValueMapHandler getFieldNameValueMapHandler(String fieldName) {
        if (fieldName.lastIndexOf("_i18n") > -1) {
            return _i18nFieldNameValueMapHandler;
        }
        return _baseFieldNameValueMapHandler;
    }

    private static class I18nFieldNameValueMapHandler
    extends BaseFieldNameValueMapHandler
    implements FieldNameValueMapHandler {
        private static final String _I18N_SUFFIX = "_i18n";

        private I18nFieldNameValueMapHandler() {
        }

        @Override
        public void handle(String fieldName, Map<String, Object> fieldNameValueMap, String value) {
            String key = fieldName.substring(fieldName.lastIndexOf(_I18N_SUFFIX) + 6);
            HashMap<String, String> valueMap = (HashMap<String, String>)fieldNameValueMap.get(fieldName);
            if (valueMap == null) {
                valueMap = new HashMap<String, String>();
                fieldNameValueMap.put(fieldName, valueMap);
            }
            valueMap.put(key, this.getValue(value));
        }
    }

    private static class BaseFieldNameValueMapHandler
    implements FieldNameValueMapHandler {
        private BaseFieldNameValueMapHandler() {
        }

        @Override
        public void handle(String fieldName, Map<String, Object> fieldNameValueMap, String value) {
            fieldNameValueMap.put(fieldName, this.getValue(value));
        }

        protected String getValue(String value) {
            if ((value = value.trim()).isEmpty()) {
                return null;
            }
            return value;
        }
    }

    public static interface FieldNameValueMapHandler {
        public void handle(String var1, Map<String, Object> var2, String var3);
    }
}

